@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-10 col-xl-10 col-xxl-8 m-auto">
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
                
        <div class="card mt-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 table__top__txt">Vehicle list</h6>
                <div class="m-0 float-right">
                    <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#vehicleModal">Add New</button>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive" >
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>Vehicle Number</th>
                                    <th>Vehicle Type</th>
                                    <th>Capacity</th>
                                    <th class="action__col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if($vehicles->isNotEmpty())
                                @foreach($vehicles as $vehicle)
                                    <tr>
                                        <td>{{ $vehicle->vehicle_number }}</td>
                                        <td>{{ $vehicle->vehicle_type }}</td>
                                        <td>{{ $vehicle->capacity }}</td>
                                        <td class="d-flex justify-content-start">
                                            <button type="button" class="btn btn-sm btn-soft-info mr-1" data-toggle="modal" data-target="#vehicleModal"
                                            data-action="edit" data-id="{{ $vehicle->id }}" data-vehicle-number="{{ $vehicle->vehicle_number }}"
                                            data-vehicle-type="{{ $vehicle->vehicle_type }}" data-capacity="{{ $vehicle->capacity }}"><i class="fas fa-edit"></i></button>
                                            <form action="{{ route('vehicle.destroy', $vehicle->id) }}" method="POST" style="display: inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-soft-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                                @else
                                <tr><td colspan="4" class="text-center">No data available in table</td></tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="vehicleModal" tabindex="-1" role="dialog" aria-labelledby="vehicleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="vehicleModalLabel">Create/Edit Vehicle</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="vehicleForm" method="POST">
                    @csrf
                    @method('POST')
                    <div class="form-group">
                        <label for="vehicle_number">Vehicle Number <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="vehicle_number" name="vehicle_number" required>
                    </div>
                    <div class="form-group">
                        <label for="vehicle_type">Vehicle Type <span class="text-danger">*</span></label>
                        {{-- <input type="text" class="form-control" id="vehicle_type" name="vehicle_type" required> --}}
                        {{ generateDropdown($vehicle_type, 'class="form-control select2 vehicle_type" id="vehicle_type" name="vehicle_type" required', '', "Select Vehicle Type") }}
                    </div>
                    <div class="form-group">
                        <label for="capacity">Capacity <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="capacity" name="capacity" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary" form="vehicleForm">Save Changes</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $('#vehicleModal').on('show.bs.modal', function(event) {
            var button = $(event.relatedTarget);
            var action = button.data('action');
            var id = button.data('id');

            var modal = $(this);
            var form = modal.find('form');
            var method = id ? 'PUT' : 'POST';
            modal.find('[name="_method"]').val(method);

            if (action === 'edit') {
                form.attr('action', '/vehicle/update/' + id);
                modal.find('.modal-title').text('Edit Vehicle');
                modal.find('#vehicle_number').val(button.data('vehicle-number'));
                modal.find('#vehicle_type').val(button.data('vehicle-type')).trigger('change');
                modal.find('#capacity').val(button.data('capacity'));
            } else {
                form.attr('action', '{{ route("vehicle.store") }}');
                modal.find('.modal-title').text('Create New Vehicle');
                modal.find('#vehicle_number').val('');
                modal.find('#vehicle_type').val('');
                modal.find('#capacity').val('');
            }
        });
    });
</script>
@endsection
