<nav class="navbar navbar-expand navbar-light bg-navbar topbar mb-4 static-top">
    <button id="sidebarToggleTop" class="btn mr-3">
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="33"
            height="33"
            viewBox="0 0 24 24"
            fill="none"
            stroke="#5c5c5c"
            stroke-width="2"
            stroke-linecap="round"
            stroke-linejoin="round"
        >
            <path d="M4 6l16 0"/>
            <path d="M4 12l16 0"/>
            <path d="M4 18l12 0"/>
        </svg>

    </button>
    <div class="dropdown mx-3 quick__link">
                <span class="dropdown-toggle" type="button" id="dropdownMenuButton"
                      data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    Quick Link
                </span>
        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
            <a class="dropdown-item" href="{{ route('student_info.create') }}">+ New Student</a>
            <a class="dropdown-item" href="{{ route('marks.create') }}">+ Marks Entry</a>
            <a class="dropdown-item" href="{{ route('collect_fee.create') }}">+ Collect Fees</a>
            <a class="dropdown-item" href="{{ route('sales.create') }}">+ Sales</a>
        </div>
    </div>
    <span class="user__mbl">{{ auth()->user()->name }}</span>
    <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown no-arrow mr-3 d-none d-md-block">
            <span class="nav-link font-weight-500">
                @if (auth()->user()->user_type=="super-admin")
                    <i class="fas fa-branch fa-fw mr-2"></i> Current Branch:
                @else
                    <i class="fas fa-branch fa-fw mr-2"></i> Your Branch:
                @endif
                <span class="ml-1" style="font-size: 16px; font-weight: 600;">
                @if (array_key_exists(auth()->user()->branch_id, $branch_data))
                        {{ $branch_data[auth()->user()->branch_id] }}
                    @endif
                </span>
            </span>
        </li>
        @if (auth()->user()->user_type=="super-admin")
            <li class="nav-item dropdown no-arrow d-none d-md-block">
                <a class="nav-link dropdown-toggle" href="#" id="searchDropdown" role="button"
                   data-toggle="dropdown"
                   aria-haspopup="true" aria-expanded="false">
                    <button class="btn btn-sm btn-success">Switch Branch</button>
                </a>
                <div class="dropdown-menu dropdown-menu-right p-3 shadow animated--grow-in"
                     aria-labelledby="searchDropdown">
                    <form class="navbar-search">
                        <div class="input-group">
                            {{ generateDropdown($branch_data, 'class="form-control branch_id_nav" id="branch_id" name="branch_id" required', auth()->user()->branch_id, '') }}
                        </div>
                    </form>
                </div>
            </li>
        @endif
        <li class="nav-item dropdown no-arrow mx-1">
            <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button"
               data-toggle="dropdown"
               aria-haspopup="true" aria-expanded="false">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="currentColor"
                >
                    <path
                        d="M17.451 2.344a1 1 0 0 1 1.41 -.099a12.05 12.05 0 0 1 3.048 4.064a1 1 0 1 1 -1.818 .836a10.05 10.05 0 0 0 -2.54 -3.39a1 1 0 0 1 -.1 -1.41z"/>
                    <path
                        d="M5.136 2.245a1 1 0 0 1 1.312 1.51a10.05 10.05 0 0 0 -2.54 3.39a1 1 0 1 1 -1.817 -.835a12.05 12.05 0 0 1 3.045 -4.065z"/>
                    <path
                        d="M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z"/>
                    <path
                        d="M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004z"/>
                </svg>

                <span class="badge badge-danger badge-counter">3+</span>
            </a>
            {{-- <div class="dropdown-list dropdown-menu dropdown-menu-right shadow animated--grow-in"
                 aria-labelledby="alertsDropdown">
                <h6 class="dropdown-header">
                    Alerts Center
                </h6>
                <a class="dropdown-item d-flex align-items-center" href="#">
                    <div class="mr-3">
                        <div class="icon-circle bg-primary">
                            <i class="fas fa-file-alt text-white"></i>
                        </div>
                    </div>
                    <div>
                        <div class="small text-gray-500">December 12, 2019</div>
                        <span class="font-weight-bold">A new monthly report is ready to download!</span>
                    </div>
                </a>
                <a class="dropdown-item text-center small text-gray-500" href="#">Show All Alerts</a>
            </div> --}}
        </li>

        <div class="topbar-divider d-none d-sm-block"></div>
        <li class="nav-item dropdown no-arrow">
            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
               data-toggle="dropdown"
               aria-haspopup="true" aria-expanded="false">
                @php
                    $profile_image_path = auth()->user()->profile_image_path ? auth()->user()->profile_image_path : '/default/profile.png';
                @endphp
                <img class="img-profile rounded-circle" src="{{ asset($profile_image_path) }}" style="max-width: 60px">
                <div class="ml-2 d-none d-lg-inline">
                    <div class="row">
                        <div class="col">
                            {{ auth()->user()->name }}
                        </div>
                    </div>
                    {{--                    <div class="row">--}}
                    {{--                        <div class="col font-italic">--}}
                    {{--                            {{ capitalizeWords(auth()->user()->user_type) }}--}}
                    {{--                        </div>--}}
                    {{--                    </div>--}}
                </div>
            </a>
            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                 aria-labelledby="userDropdown">
                <a class="dropdown-item" href="{{route('profile.index')}}">
                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                    <span>Profile</span>
                </a>
                <a class="dropdown-item" href="{{route('password-update')}}">
                    <i class="fas fa-key fa-sm fa-fw mr-2 text-gray-400"></i>
                    <span>Change Password</span>
                </a>

                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal"
                   data-target="#logoutModal">
                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                    <span>Logout</span>
                </a>
            </div>
        </li>
    </ul>
</nav>

<!-- Modal Logout -->
<div class="modal fade" id="logoutModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelLogout"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabelLogout">Log Out</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to logout?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary" data-dismiss="modal">Cancel
                </button>
                {{-- <a href="login.html" class="btn btn-primary">Logout</a> --}}
                <a href="{{ route('logout') }}" class="btn btn-primary"
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    Logout
                </a>
                <form id="logout-form" action="{{ route('logout') }}" method="POST">
                    @csrf
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        $(document).on('change', '.branch_id_nav', function () {
            let branch_id = $(this).val();
            if (branch_id) {
                const csrfToken = document.head.querySelector('meta[name="csrf-token"]').content;
                const buttonId = `#attendance-btn-${branch_id}`;
                $.post("{{ route('branch-switch') }}", {
                    _token: csrfToken,
                    branch_id: branch_id,
                }, function (response) {
                    if (response.success) {
                        toastr.success(response.message, 'Success');
                        location.reload()
                    }
                });
            }
        });
    </script>
@endpush
