@php
$route = Route::currentRouteName();
$routePrefix = Request()->route()->getPrefix();
$routePrefix = ltrim($routePrefix, '/');
$prefixFirstItem = explode('/',$routePrefix)[0];
// dd($prefixFirstItem);
@endphp

<ul class="navbar-nav sidebar sidebar-light accordion" id="accordionSidebar">
    <a class="sidebar-brand d-flex align-items-center justify-content-center" href="{{URL('/')}}">
        <div class="sidebar-brand-icon">
            @php
                $logo_path = get_setting_value(Settings::SCHOOL_LOGO) ? get_setting_value(Settings::SCHOOL_LOGO) : 'default/default.png';
            @endphp
            <img src="{{ asset($logo_path) }}" class="img-fluid">
        </div>
        {{-- <div class="sidebar-brand-text mx-3">EduEasy</div> --}}
    </a>
{{--    <hr class="sidebar-divider my-0">--}}
    <li class="nav-item active">
        <a class="nav-link" href="{{URL('/')}}">
            <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="32"
                viewBox="0 0 24 24"
                fill="none"
                stroke="#000000"
                stroke-width="1"
                stroke-linecap="round"
                stroke-linejoin="round"
            >
                <path d="M5 4h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-6a1 1 0 0 1 1 -1" />
                <path d="M5 16h4a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1" />
                <path d="M15 12h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-6a1 1 0 0 1 1 -1" />
                <path d="M15 4h4a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1" />
            </svg>
            <span>Dashboard</span>
        </a>
    </li>
{{--    <hr class="sidebar-divider">--}}
    @can('academic')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseAcademic"
            aria-expanded="true" aria-controls="collapseBootstrap">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M3 19a9 9 0 0 1 9 0a9 9 0 0 1 9 0" />
                    <path d="M3 6a9 9 0 0 1 9 0a9 9 0 0 1 9 0" />
                    <path d="M3 6l0 13" />
                    <path d="M12 6l0 13" />
                    <path d="M21 6l0 13" />
                </svg>


                <span>Academic Management</span>
            </a>
            <div id="collapseAcademic" class="collapse {{$prefixFirstItem=='academic'?'show':''}}" aria-labelledby="headingBootstrap" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">

                    {!! menuItem('academic-setup.index', 'academic.branches.view', 'Academic Setup') !!}
                    {!! menuItem('subjects.index', 'academic.subjects-list.view', 'Subjects List') !!}
                    {!! menuItem('subjects_assigns.index', 'academic.subjects-assigns.view', 'Subjects Assigns') !!}
                    {{-- {!! menuItem('subject-setup.index', 'academic.branches.view', 'Subject Setup') !!} --}}
                    {!! menuItem('branches.index', 'academic.branches.view', 'Branches') !!}
                    {!! menuItem('building-setup.index', 'academic.buildings.view', 'Building Setup') !!}
                    {{-- {!! menuItem('building_floors.index', 'academic.building_floors.view', 'Building Floors') !!} --}}
                    {{-- {!! menuItem('class_rooms.index', 'academic.class_rooms.view', 'Class Room') !!} --}}
                    {!! menuItem('academic-years.index', 'academic.academic-year.view', 'Academic Year') !!}
                    {!! menuItem('class-routine.index', 'academic.class-routine.view', 'Class Routine') !!}
                    {!! menuItem('class_teachers.index', 'academic.assign-class-teacher.create', 'Assign Class Teacher') !!}
                    {!! menuItem('teachers-enroll.index', 'academic.teacher-enroll.view', 'Teacher Enrollment') !!}
                    {{-- {!! menuItem('subject-teachers.index', 'academic.assign-class-teacher.view', 'Assign Subject Teacher') !!} --}}

                </div>
            </div>
        </li>
    @endcan

    @can('online-admission')
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseOnlineAdmission"
           aria-expanded="true"
           aria-controls="collapseBootstrap">

            <svg xmlns="http://www.w3.org/2000/svg"
                width="32" height="32" viewBox="0 0 24 24" fill="none"
                stroke="#000000" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
            <!-- document -->
            <path d="M14 3H6a2 2 0 0 0-2 2v14a1 1 0 0 0 1 1h10a2 2 0 0 0 2-2V8z" />
            <!-- folded corner -->
            <path d="M14 3v5h5" />
            <!-- user silhouette -->
            <path d="M9.5 13a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5z" />
            <path d="M6.5 18c.5-1.5 2-2.5 3.5-2.5s3 1 3.5 2.5" />
            <!-- plus sign (admission / add) -->
            <path d="M19 15v4" />
            <path d="M17 17h4" />
            </svg>

            <span>Online Admission</span>
        </a>
        <div id="collapseOnlineAdmission" class="collapse {{ $prefixFirstItem == 'admission' ? 'show' : '' }}" aria-labelledby="headingBootstrap" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('admission-setting.index', 'online-admission.applicant-list', 'Admission Setting') !!}
                {!! menuItem('admission-fee.index', 'online-admission.applicant-list', 'Admission Fees') !!}
                {!! menuItem('online-admission.index', 'online-admission.applicant-list', 'Applicant List') !!}
                {!! menuItem('online-admission.selected-applicant-list', 'online-admission.applicant-list', 'Selected List') !!}
                {!! menuItem('online-admission.admitted-ist', 'online-admission.qualified-list', 'Admitted List') !!}
            </div>
        </div>
    </li>
    @endcan


    @can('student')
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseStudent"
           aria-expanded="true"
           aria-controls="collapseStudent">
            <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="32"
                viewBox="0 0 24 24"
                fill="none"
                stroke="#000000"
                stroke-width="1"
                stroke-linecap="round"
                stroke-linejoin="round"
            >
                <path d="M5 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" />
                <path d="M3 21v-2a4 4 0 0 1 4 -4h4c.96 0 1.84 .338 2.53 .901" />
                <path d="M16 3.13a4 4 0 0 1 0 7.75" />
                <path d="M16 19h6" />
                <path d="M19 16v6" />
            </svg>


            <span>Student Management </span>
        </a>
        <div id="collapseStudent" class="collapse {{ $prefixFirstItem == 'student-info' ? 'show' : '' }}" aria-labelledby="headingStudent" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('student_info.index', 'student.student-list.view', 'Student Manage') !!}
                {!! menuItem('student.promotion.create', 'student.promotion.create', 'Student Promotion') !!}
                {!! menuItem('student.graduation.create', 'student.graduation.create', 'Student Graduation') !!}
                {!! menuItem('import_student.form', 'student.import.view', 'Import Student') !!}
                {!! menuItem('student.id-card.index', 'student.id-card.view', 'Student ID Card') !!}
                {!! menuItem('occupation.index', 'student.occupation.view', 'Guardian Occupation') !!}
                {!! menuItem('guardian_relation.index', 'student.relations.view', 'Guardian Relation') !!}
            </div>
        </div>
    </li>
    @endcan

    @can('teacher')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTeacher"
                aria-expanded="true"
                aria-controls="collapseTeacher">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" />
                    <path d="M6 21v-2a4 4 0 0 1 4 -4h2.5" />
                    <path d="M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                    <path d="M19.001 15.5v1.5" />
                    <path d="M19.001 21v1.5" />
                    <path d="M22.032 17.25l-1.299 .75" />
                    <path d="M17.27 20l-1.3 .75" />
                    <path d="M15.97 17.25l1.3 .75" />
                    <path d="M20.733 20l1.3 .75" />
                </svg>

                <span>Teacher Management </span>
            </a>
            <div id="collapseTeacher" class="collapse {{ $routePrefix == 'teacher' ? 'show' : '' }}" aria-labelledby="headingTeacher" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('teacher.index', 'teacher.teacher-list.view', 'Teacher List') !!}


                </div>
            </div>
        </li>
    @endcan

    @can('exam-result')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseResult" aria-expanded="true" aria-controls="collapseResult">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M8 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h5.697" />
                    <path d="M18 12v-5a2 2 0 0 0 -2 -2h-2" />
                    <path d="M8 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z" />
                    <path d="M8 11h4" />
                    <path d="M8 15h3" />
                    <path d="M16.5 17.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0" />
                    <path d="M18.5 19.5l2.5 2.5" />
                </svg>

                <span>Exam & Result </span>
            </a>
            <div id="collapseResult" class="collapse {{ $prefixFirstItem == 'result' ? 'show' : '' }}" aria-labelledby="headingTable" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('exam-setup.index', 'exam-result.grade.view', 'Exam Setup') !!}
                    {!! menuItem('markHeadAssign.index', 'exam-result.assign-head.view', 'Assign Head') !!}
                    {!! menuItem('marks.create', 'exam-result.marks-list.create', 'Marks Entry') !!}
                    {{-- {!! menuItem('marks.index', 'exam-result.marks-list.view', 'Marks List') !!} --}}
                    {{-- {!! menuItem('marks.sheet', 'exam-result.marks-sheet.view', 'Marks Sheet') !!} --}}
                    {{-- {!! menuItem('reports.result-report', 'exam-result.marks-sheet.view', 'Result Report') !!} --}}
                    {!! menuItem('admit-card.index', 'exam-result.admit-card.view', 'Admit Card') !!}
                    {!! menuItem('seat-plan.index', 'exam-result.seat-plan.view', 'Seat Plan') !!}
                    @if (auth()->user()->user_type == 'teacher')
                        <a class="collapse-item" href="{{ route('teacher.marks.entry') }}">Marks Entry</a>
                    @endif
                </div>
            </div>
        </li>
    @endcan

    {{-- <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseOnlineAdmission" aria-expanded="true" aria-controls="collapseOnlineAdmission">
            <i class="fas fa-chalkboard"></i>
            <span>Online Admission</span>
        </a>
        <div id="collapseOnlineAdmission" class="collapse" aria-labelledby="headingOnlineAdmission" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <a class="collapse-item" href="">Online Applicants</a>
            </div>
        </div>
    </li> --}}

    @can('attendance')
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseAttendance" aria-expanded="true" aria-controls="collapseAttendance">
            <!--
unicode: "fec4"
version: "3.3"
-->
            <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="32"
                viewBox="0 0 24 24"
                fill="none"
                stroke="#000000"
                stroke-width="1"
                stroke-linecap="round"
                stroke-linejoin="round"
            >
                <path d="M13 18l-5 3v-3h-2a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v4.5" />
                <path d="M19 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                <path d="M22 22a2 2 0 0 0 -2 -2h-2a2 2 0 0 0 -2 2" />
            </svg>
            <span>Student Attendance</span>
        </a>
        <div id="collapseAttendance" class="collapse {{$prefixFirstItem=='attendance'?'show':''}}"aria-labelledby="headingAttendance" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('student_attendance.my-student', 'attendance.student.my-student', 'Take Attendance') !!}
                {!! menuItem('student_attendance.create', 'attendance.student.create', 'Others Attendance') !!}
                {!! menuItem('student_attendance.report', 'attendance.report.view', 'Attendance Report') !!}
                {!! menuItem('student_attendance.report.date_to_date', 'attendance.student.report.date_to_date', 'Date To Date Report') !!}
            </div>
        </div>
    </li>
    @endcan
{{-- {{dd(auth()->user()->can('accounting'))}} --}}

    @can('hsc')
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseHsc" aria-expanded="true" aria-controls="collapseHsc">

            <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="32"
                viewBox="0 0 24 24"
                fill="none"
                stroke="#000000"
                stroke-width="1"
                stroke-linecap="round"
                stroke-linejoin="round"
            >
                <path d="M20 6v12a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2z" />
                <path d="M10 16h6" />
                <path d="M13 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                <path d="M4 8h3" />
                <path d="M4 12h3" />
                <path d="M4 16h3" />
            </svg>

            <span>HSC</span>
        </a>
        <div id="collapseHsc" class="collapse {{$prefixFirstItem=='hsc'?'show':''}}"aria-labelledby="headingHsc" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('group-subject.index', 'hsc.group-subject.view', 'Subject Grouping') !!}
                {!! menuItem('hsc-admission.index', 'hsc.hsc-admission.view', 'HSC Applicant') !!}
            </div>
        </div>
    </li>
    @endcan

    @can('accounting')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseAccounts"
                aria-expanded="true"
                aria-controls="collapseAccounts">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M9 14c0 1.657 2.686 3 6 3s6 -1.343 6 -3s-2.686 -3 -6 -3s-6 1.343 -6 3z" />
                    <path d="M9 14v4c0 1.656 2.686 3 6 3s6 -1.344 6 -3v-4" />
                    <path d="M3 6c0 1.072 1.144 2.062 3 2.598s4.144 .536 6 0c1.856 -.536 3 -1.526 3 -2.598c0 -1.072 -1.144 -2.062 -3 -2.598s-4.144 -.536 -6 0c-1.856 .536 -3 1.526 -3 2.598z" />
                    <path d="M3 6v10c0 .888 .772 1.45 2 2" />
                    <path d="M3 11c0 .888 .772 1.45 2 2" />
                </svg>

                <span>Accounting</span>
            </a>
            <div id="collapseAccounts" class="collapse {{ $prefixFirstItem == 'accounting' ? 'show' : ''}}" aria-labelledby="headingAccounts" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('fee_types.index', 'accounting.fees-type.view', 'Fees Type') !!}
                    {!! menuItem('class_fees.index', 'accounting.class-wise-fees.view', 'Fees Setup') !!}
                    {!! menuItem('student_discount.create', 'accounting.fees-discount.view', 'Fees Discount') !!}
                    {!! menuItem('assign_discount.index', 'accounting.class-fees.view', 'Assign Discount') !!}
                    {!! menuItem('collect_fee.create', 'accounting.collect-fees.create', 'Collect Fees') !!}
                    {!! menuItem('collect_fee.index', 'accounting.collect-fees.view', 'Fee Invoice') !!}
                    {!! menuItem('collect_fee.due-list', 'accounting.due-list.view', 'Due Fees') !!}
                    {!! menuItem('accounting_head.index', 'accounting.accounting-head.view', 'Accounting Head') !!}
                    {!! menuItem('income.index', 'accounting.income.view', 'Income') !!}
                    {!! menuItem('expense.index', 'accounting.expense.view', 'Expense') !!}
                    {!! menuItem('bank_account.index', 'accounting.bank-account.view', 'Bank Account') !!}
                    {!! menuItem('bank_deposit.index', 'accounting.bank-deposit.view', 'Bank Deposit') !!}
                    {!! menuItem('bank_withdraw.index', 'accounting.bank-withdraw.view', 'Bank Withdraw') !!}
                    {!! menuItem('check-books.index', 'accounting.bank-withdraw.view', 'Bank Check Book') !!}
                </div>
            </div>
        </li>
    @endcan

    @can('sms-management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseSmsManagement"
                aria-expanded="true"
                aria-controls="collapseSmsManagement">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M11 3h10v8h-3l-4 2v-2h-3z" />
                    <path d="M15 16v4a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1h2" />
                    <path d="M10 18v.01" />
                </svg>

                <span>SMS Management </span>
            </a>
            <div id="collapseSmsManagement" class="collapse {{$prefixFirstItem == 'sms' ? 'show' : ''}}" aria-labelledby="headingSmsManagement" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('student-sms.department-wise-sms', 'sms-management.student-sms.create', 'Send To All') !!}
                    {!! menuItem('student-sms.create', 'sms-management.student-sms.create', 'Send By Class') !!}
                    {!! menuItem('employee-sms.create', 'sms-management.employee-sms.create', 'Send To Staff') !!}
                    {!! menuItem('general-sms.create', 'sms-management.general-sms.create', 'General SMS') !!}
                    {!! menuItem('sms-reports', 'sms-management.sms-report.view', 'SMS Reports') !!}
                    {!! menuItem('date-wise-sms-reports', 'sms-management.sms-report.view', 'Daily Report') !!}
                </div>
            </div>
        </li>
    @endcan

    @can('hr-payroll')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseHRM" aria-expanded="true" aria-controls="collapseHRM">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M14 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z" />
                    <path d="M7 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z" />
                    <path d="M21 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z" />
                    <path d="M14 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z" />
                    <path d="M12 8v8" />
                    <path d="M6.316 12.496l4.368 -4.992" />
                    <path d="M17.684 12.496l-4.366 -4.99" />
                </svg>


                <span>HR & Payroll </span>
            </a>
            <div id="collapseHRM" class="collapse {{ $prefixFirstItem == 'hr' ? 'show' : '' }}" aria-labelledby="headingHRM" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('designation.index', 'hr-payroll.designation.view', 'Designation') !!}
                    {!! menuItem('hr-department.index', 'hr-payroll.department.view', 'Department') !!}
                    {!! menuItem('employee_type.index', 'hr-payroll.employee-type.view', 'Employee Types') !!}
                    {!! menuItem('employees.index', 'hr-payroll.employees.view', 'Employees') !!}
                    {!! menuItem('salary-setting.index', 'hr-payroll.salary-setting.view', 'Salary Setting') !!}
                    {!! menuItem('employee-salary.index', 'hr-payroll.employee-salary.view', 'Employee Salary') !!}
                    {!! menuItem('monthly-salary.index', 'hr-payroll.monthly-salary.view', 'Monthly Salary') !!}
                    {!! menuItem('leave-type.index', 'hr-payroll.leave-type.view', 'Leave Type') !!}
                    {!! menuItem('leaves.index', 'hr-payroll.leaves.view', 'Leave List') !!}
                    {!! menuItem('leaves-request.index', 'hr-payroll.leaves-request.view', 'Leave Request') !!}
                    {!! menuItem('employee.attendance.index', 'hr-payroll.attendance.view', 'Attendance') !!}
                </div>
            </div>
        </li>
    @endcan

    @can('transport-management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseTransport" aria-expanded="true" aria-controls="collapseTransport">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                    <path d="M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                    <path d="M4 17h-2v-11a1 1 0 0 1 1 -1h14a5 7 0 0 1 5 7v5h-2m-4 0h-8" />
                    <path d="M16 5l1.5 7l4.5 0" />
                    <path d="M2 10l15 0" />
                    <path d="M7 5l0 5" />
                    <path d="M12 5l0 5" />
                </svg>

                <span>Transport Management</span>
            </a>
            <div id="collapseTransport" class="collapse {{ $prefixFirstItem == 'transport' ? 'show' : '' }}" aria-labelledby="headingTransport" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {{-- {!! menuItem('vehicle.index', 'transport-management.vehicles.view', 'Vehicle') !!} --}}
                    {{-- {!! menuItem('transport-route.index', 'transport-management.routes.view', 'Routes') !!} --}}
                    {!! menuItem('stoppage.index', 'transport-management.stoppage.view', 'Stoppages') !!}
                    {!! menuItem('assign-stoppage.index', 'transport-management.assign-student.view', 'Assign To Students') !!}
                    {{-- {!! menuItem('multi.assign-stoppage.index', 'transport-management.multiple-assign-student.create', 'Multi Students Assign') !!} --}}
                </div>
            </div>
        </li>
    @endcan

    @can('hostel-management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseHostel"
                aria-expanded="true" aria-controls="collapseHostel">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M8 9l5 5v7h-5v-4m0 4h-5v-7l5 -5m1 1v-6a1 1 0 0 1 1 -1h10a1 1 0 0 1 1 1v17h-8" />
                    <path d="M13 7l0 .01" />
                    <path d="M17 7l0 .01" />
                    <path d="M17 11l0 .01" />
                    <path d="M17 15l0 .01" />
                </svg>

                <span>Hostel Management</span>
            </a>
            <div id="collapseHostel" class="collapse {{$prefixFirstItem=='hostel'?'show':''}}" aria-labelledby="headingHostel" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">

                    {!! menuItem('hostel.index', 'hostel-management.hostels.view', 'Hostels') !!}
                    {{-- {!! menuItem('room-type.index', 'hostel-management.room-type.view', 'Room Type') !!} --}}
                    {{-- {!! menuItem('hostel-room.index', 'hostel-management.hostel-room.view', 'Hostel Room') !!} --}}
                    {!! menuItem('assign_room.index', 'hostel-management.hostel-room.view', 'Assign to Student') !!}
                    {{-- {!! menuItem('multi.assign_room.index', 'hostel-management.multiple-assign.create', 'Multi Student Assign') !!} --}}

                </div>
            </div>
        </li>
    @endcan

    @can('library-management')
        {{-- <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseLibrary"
                aria-expanded="true" aria-controls="collapseLibrary">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M14 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5" />
                    <path d="M11 16h-5a2 2 0 0 0 -2 2" />
                    <path d="M15 16l3 -3l3 3" />
                    <path d="M18 13v9" />
                </svg>

                <span>Library Management</span>
        </a>
        <div id="collapseLibrary" class="collapse {{$prefixFirstItem=='library'?'show':''}}" aria-labelledby="headingHostel" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('booklist.index', 'library-management.books.view', 'Book List') !!}
                {!! menuItem('bookmember.create', 'library-management.member.create', 'Add Member') !!}
                {!! menuItem('bookmember.index', 'library-management.books.issue', 'Issue/Return Book') !!}
                </div>
            </div>
        </li> --}}
    @endcan

    @can('syllabus-plan')
        {{-- <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseSyllabus"
                aria-expanded="true" aria-controls="collapseSyllabus">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" />
                    <path d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z" />
                    <path d="M9 12h6" />
                    <path d="M9 16h6" />
                </svg>

                <span>Syllabus Plan</span>
            </a>
            <div id="collapseSyllabus" class="collapse {{$prefixFirstItem=='syllabus'?'show':''}}" aria-labelledby="headingHostel" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('lesson.index', 'syllabus-plan.lesson.view', 'Lesson') !!}
                    {!! menuItem('lesson_topic.index', 'syllabus-plan.topic.view', 'Topic') !!}
                    {!! menuItem('syllabus.status', 'syllabus-plan.status.view', 'Syllabus Status') !!}
                </div>
            </div>
        </li> --}}
    @endcan

    @can('homework')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseHomework"
                aria-expanded="true" aria-controls="collapseHomework">
                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M15.5 13a3.5 3.5 0 0 0 -3.5 3.5v1a3.5 3.5 0 0 0 7 0v-1.8" />
                    <path d="M8.5 13a3.5 3.5 0 0 1 3.5 3.5v1a3.5 3.5 0 0 1 -7 0v-1.8" />
                    <path d="M17.5 16a3.5 3.5 0 0 0 0 -7h-.5" />
                    <path d="M19 9.3v-2.8a3.5 3.5 0 0 0 -7 0" />
                    <path d="M6.5 16a3.5 3.5 0 0 1 0 -7h.5" />
                    <path d="M5 9.3v-2.8a3.5 3.5 0 0 1 7 0v10" />
                </svg>


                <span>Homework</span>
            </a>
            <div id="collapseHomework" class="collapse {{$prefixFirstItem=='homework'?'show':''}}" aria-labelledby="headingHostel" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('homework.index', 'homework.homework.view', 'Homework') !!}
                    {!! menuItem('homework.result.view', 'homework.homework.view', 'Student Homework') !!}
                </div>
            </div>
        </li>
    @endcan

    @can('holiday')
        {{-- <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseHoliday" aria-expanded="true" aria-controls="collapsePage">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5" />
                    <path d="M16 3v4" />
                    <path d="M8 3v4" />
                    <path d="M4 11h16" />
                    <path d="M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" />
                    <path d="M19.001 15.5v1.5" />
                    <path d="M19.001 21v1.5" />
                    <path d="M22.032 17.25l-1.299 .75" />
                    <path d="M17.27 20l-1.3 .75" />
                    <path d="M15.97 17.25l1.3 .75" />
                    <path d="M20.733 20l1.3 .75" />
                </svg>

                <span>Academic Calendar</span>
            </a>
            <div id="collapseHoliday" class="collapse {{$prefixFirstItem=='holiday'?'show':''}}" aria-labelledby="headingPage" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('holiday.index', 'holiday.holiday.view', 'Manage Calendar') !!}
                </div>
            </div>
        </li> --}}
    @endcan


    @can('notice')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseNotice" aria-expanded="true" aria-controls="collapsePage">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6" />
                    <path d="M9 17v1a3 3 0 0 0 6 0v-1" />
                    <path d="M21 6.727a11.05 11.05 0 0 0 -2.794 -3.727" />
                    <path d="M3 6.727a11.05 11.05 0 0 1 2.792 -3.727" />
                </svg>

                <span>Notice </span>
            </a>
            <div id="collapseNotice" class="collapse {{$prefixFirstItem=='notice'?'show':''}}" aria-labelledby="headingPage" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('notice.index', 'notice.notice.view', 'Notice') !!}
                </div>
            </div>
        </li>
    @endcan

    @can('inventory')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseInventory" aria-expanded="true" aria-controls="collapsePage">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M12 12l-6.5 5.5" />
                    <path d="M12 3v9h9" />
                    <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                    <path d="M12 12l5 7.5" />
                </svg>

                <span>Inventory </span>
            </a>
            <div id="collapseInventory" class="collapse {{$prefixFirstItem=='inventory'?'show':''}}" aria-labelledby="headingPage" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('product.index', 'inventory.product.view', 'Product') !!}
                    {!! menuItem('sales.index', 'inventory.sales.view', 'Sales') !!}
                </div>
            </div>
        </li>
    @endcan

    @can('certificate')
    {{-- <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseCentificate" aria-expanded="true" aria-controls="collapsePage">

            <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="32"
                viewBox="0 0 24 24"
                fill="none"
                stroke="#000000"
                stroke-width="1"
                stroke-linecap="round"
                stroke-linejoin="round"
            >
                <path d="M15 15m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0" />
                <path d="M13 17.5v4.5l2 -1.5l2 1.5v-4.5" />
                <path d="M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -1 1.73" />
                <path d="M6 9l12 0" />
                <path d="M6 12l3 0" />
                <path d="M6 15l2 0" />
            </svg>

            <span>Certificate</span>
        </a>
        <div id="collapseCentificate" class="collapse {{$prefixFirstItem=='certificates'?'show':''}}" aria-labelledby="headingPage" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('certificate-templates.index', 'certificate.templates.view', 'Certificate Template') !!}
                {!! menuItem('student-certificate.index', 'certificate.student.view', 'Certificate List') !!}
            </div>
        </div>
    </li> --}}
    @endcan

    @can('report')
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseReport" aria-expanded="true" aria-controls="collapsePage">

            <svg
                xmlns="http://www.w3.org/2000/svg"
                width="32"
                height="32"
                viewBox="0 0 24 24"
                fill="none"
                stroke="#000000"
                stroke-width="1"
                stroke-linecap="round"
                stroke-linejoin="round"
            >
                <path d="M3 13a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                <path d="M9 9a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                <path d="M15 5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" />
                <path d="M4 20h14" />
            </svg>

            <span>Report </span>
        </a>
        <div id="collapseReport" class="collapse {{$prefixFirstItem=='report'?'show':''}}" aria-labelledby="headingPage" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                {!! menuItem('report.students.index', 'report.students.view', 'Student') !!}
                {!! menuItem('report.accounting.index', 'report.accounting.view', 'Accounting') !!}
                {!! menuItem('report.exam-result.index', 'report.exam-result.view', 'Exam & Result') !!}
                {!! menuItem('report.attendance.index', 'report.attendance.view', 'Attendance') !!}
                {{-- {!! menuItem('library.report.index', 'report.library.view', 'Library') !!} --}}
                {{-- {!! menuItem('syllabus.status.report', 'report.syllabus.view', 'Syllabus') !!} --}}
                {{-- {!! menuItem('hostel.report.index', 'report.hostel.view', 'Hostel') !!} --}}
                {{-- {!! menuItem('transport.report.index', 'report.transport.view', 'Transport') !!} --}}
                {!! menuItem('multi-branch.report', 'report.transport.view', 'Multi Branch Report') !!}
            </div>
        </div>
    </li>
    @endcan
    @can('role-permission')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseRP" aria-expanded="true" aria-controls="collapsePage">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M12 17v4" />
                    <path d="M10 20l4 -2" />
                    <path d="M10 18l4 2" />
                    <path d="M5 17v4" />
                    <path d="M3 20l4 -2" />
                    <path d="M3 18l4 2" />
                    <path d="M19 17v4" />
                    <path d="M17 20l4 -2" />
                    <path d="M17 18l4 2" />
                    <path d="M9 6a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                    <path d="M7 14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2" />
                </svg>

                <span>Role & Permission </span>
            </a>
            <div id="collapseRP" class="collapse {{($prefixFirstItem=='permissions' || $routePrefix=='roles') ? 'show' : ''}}" aria-labelledby="headingPage" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('roles.index', 'role-permission.roles.index', 'Role') !!}
                    {!! menuItem('permissions.users.list', 'role-permission.users.view', 'User List') !!}
                </div>
            </div>
        </li>
    @endcan


    @can('api-key')
    <li class="nav-item">
        <a class="nav-link collapsed" href="{{ route('apikey.index')}}" >
            <i class="fas fa-key"></i>
            <span>API Key </span>
        </a>
    </li>
    @endcan

    @can('setting-management')
        <li class="nav-item">
            <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseSettingManage"
                aria-expanded="true"
                aria-controls="collapseForm">

                <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="32"
                    height="32"
                    viewBox="0 0 24 24"
                    fill="none"
                    stroke="#000000"
                    stroke-width="1"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                >
                    <path d="M11.445 20.913a1.665 1.665 0 0 1 -1.12 -1.23a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.31 .318 1.643 1.79 .997 2.694" />
                    <path d="M15 19l2 2l4 -4" />
                    <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                </svg>

                <span>Setting Management </span>
            </a>
            <div id="collapseSettingManage" class="collapse {{$routePrefix == 'settings' ? 'show' : ''}}" aria-labelledby="headingForm" data-parent="#accordionSidebar">
                <div class="bg-white py-2 collapse-inner rounded">
                    {!! menuItem('setting.index', 'setting-management.setting.index', 'General Settings') !!}
                    {!! menuItem('setting.accounting', 'setting-management.setting.accounting', 'Accounting Settings') !!}
                </div>
            </div>
        </li>
    @endcan
</ul>
