@extends('layouts.master')

@section('content')

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Profile Card -->
            <div class="card shadow-lg">
                <div class="card-body text-center">
                    <div class="profile-img mb-3">
                        <img src="{{ asset($user->profile_image_path ?? 'default-profile.png') }}" alt="Profile Image" class="rounded-circle img-thumbnail" width="120">
                    </div>
                    <h4 class="mb-1">{{ $user->first_name }} {{ $user->last_name }}</h4>
{{--                    <p class="text-muted">{{ ucfirst($user->user_type ?? 'User') }}</p>--}}
                    {{-- <a href="{{ route('profile.edit', $user->id) }}" class="btn btn-primary btn-sm">Edit Profile</a> --}}
                </div>
            </div>

            <!-- User Details -->
            <div class="card mt-4">
                <div class="">
                    <h4 class="mb-0 text-gray-900">Profile Information</h4>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item px-0"><strong>Email:</strong> {{ $user->email }}</li>
                        <li class="list-group-item px-0"><strong>Phone:</strong> {{ $user->phone_number ?? 'N/A' }}</li>
                        <li class="list-group-item px-0"><strong>Branch:</strong> {{ $branch->branch_name ?? 'Not Assigned' }}</li>
                        <li class="list-group-item px-0"><strong>Status:</strong>
                            <span class="badge {{ $user->status ? 'badge-success' : 'badge-danger' }}">
                                {{ $user->status ? 'Active' : 'Inactive' }}
                            </span>
                        </li>
                    </ul>
                    <a href="{{route('password-update')}}" class="mt-4 d-block">Change Password</a>
                </div>
            </div>

            <!-- Error & Success Messages -->
            @if ($errors->any())
                <div class="alert alert-danger mt-4">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if (session('status'))
                <div class="alert alert-success mt-4">
                    {{ session('status') }}
                </div>
            @endif
        </div>
    </div>
</div>

@endsection
