@extends('layouts.master')
@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'daily-collection'])
    <div class="card mt-2">
        <div class="card-body">
            <form action="{{ route('accounting.daily-collection.report') }}" method="GET">
                <div class="row">
                    <div class="form-group col-md-2 mb-0 col-6">
                        <input type="text" id="reportrange" name="date_range" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2 col-6">
                        <button class="btn btn-sm btn-info">Search</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Fee Collection Report</h6>
            <div>
                <x-report-actions
                    :print="true"
                    :export_excel="true"
                    :export_pdf="true"
                />
            </div>
        </div>
        <div class="row pt-2">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table_content table-bordered" id="studentsTable">
                        <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Date</th>
                            <th>Total Fee</th>
                            <th>Total Discount</th>
                            <th>Total Late Fine</th>
                            <th>Total Amount</th>
                        </tr>
                        </thead>
                        <tbody>
                        @php
                            $sn = 1;
                        @endphp
                        @forelse ($dailyCollections as $dailyCollection)
                            <tr>
                                <td>{{$sn++}}</td>
                                <td>{{ view_date_format($dailyCollection->invoice_date) }}</td>
                                <td>{{round($dailyCollection->total_amount)}}</td>
                                <td>{{round($dailyCollection->total_discount)}}</td>
                                <td>{{round($dailyCollection->total_late_fine)}}</td>
                                <td>{{round($dailyCollection->total_paid)}}</td>
                            </tr>
                        @empty

                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@section('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>

        const exportExcelOptions = {
            url: '{{ route("accounting.daily-collection.export-excel") }}',
            filename: 'daily-collection',
            extraData: @json(request()->query()),
        };

        const exportPdfOptions = {
            url: '{{ route("accounting.daily-collection.export-pdf") }}',
            filename: 'daily-collection',
            extraData: @json(request()->query()),
        };

        const exportPrintOptions = {
            url: '{{ route("accounting.daily-collection.export-print") }}',
            filename: 'daily-collection',
            extraData: @json(request()->query()),
        };
    </script>
@endsection
@endsection

