@extends('layouts.master')

@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'due-fees-report'])
    <div class="card mt-4">
        <div class="card-body card__head">
            <form action="{{ route('accounting.due-fees.report') }}" method="GET">

                        <div class="row">
                            <div class="col-lg-2">
                                <div class="form-group mb-2">
                                    {{ generateDropdown($studentClasses, 'class="form-control form-control-sm student_class select2" id="student_class" name="student_class" required', request()->query('student_class'), 'Select Class') }}
                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-group mb-2">
                                    {{ generateDropdown([], 'class="form-control form-control-sm section" id="section" name="section"', request()->query('section'), 'Select Section') }}
                                </div>
                            </div>

                            <div class="form-group col-lg-2">
                                <input type="text" id="reportrange" name="date" class="form-control form-control-sm">
                            </div>
                            <div class="form-group col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
            </form>
        </div>
    </div>
    <div class="card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Due Fees Report</h6>
            <div>
                <x-report-actions
                    :print="true"
                    :export_excel="true"
                    :export_pdf="true"
                />
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 pt-3">
                <div class="table-responsive">
                    <table class="table" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Student ID</th>
                                <th>Name</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Total Amount</th>
                                <th>Paid Amount</th>
                                <th>Due Amount</th>
                            </tr>
                        </thead>

                        <tbody>
                            @php
                                $sn = 1;
                            @endphp
                            @forelse ($dueFees as $dueFee)
                                <tr>
                                    {{-- {{ dd($dueFee) }} --}}
                                    <td>{{ $sn++ }}</td>
                                    <td>{{ $dueFee->student_id_no }}</td>
                                    <td>{{ $dueFee->name }}</td>
                                    <td>{{ $dueFee->class_name }}</td>
                                    <td>{{ $dueFee->section_name ?? '--' }}</td>
                                    <td>{{ round($dueFee->total_assigned_fee) }}</td>
                                    <td>{{ round($dueFee->total_paid_fee) }}</td>
                                    <td>{{ round($dueFee->total_due_fee) }}</td>
                                </tr>
                            @empty
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>
        $('.student_class').on('change', function() {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        if (student_class_id != '') {
            getSection(student_class_id);
        }

        function getSection(student_class_id) {

            let section_id = "{{ request()->query('section') ?? '' }}";
            if (student_class_id) {
                $.get('{{ route('sections.list_by_class') }}', {
                    student_class_id: student_class_id
                }, function(response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Select Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name +
                                '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name +
                                '</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }

        const exportExcelOptions = {
            url: '{{ route("accounting.due-fees.export-excel") }}',
            filename: 'due-fees',
            extraData: @json(request()->query()),
        };

        const exportPdfOptions = {
            url: '{{ route("accounting.due-fees.export-pdf") }}',
            filename: 'due-fees',
            extraData: @json(request()->query()),
        };

        const exportPrintOptions = {
            url: '{{ route("accounting.due-fees.export-print") }}',
            filename: 'due-fees',
            extraData: @json(request()->query()),
        };
    </script>
@endpush
