@extends('layouts.master')
@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'expense-report'])
    <div class="card mt-2">
        <div class="card-body">
            <form action="{{ route('accounting.expense.report') }}" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Expense Report</h6>
            <div class="d-flex justify-content-end">
                <x-report-actions 
                    :print="true"
                    :export_excel="true"
                    :export_pdf="true"
                />
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
          
                <div class="table-responsive">
                    <table class="table table-strip" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>ID</th>
                                <th>Date</th>
                                <th>Accounting Head</th>
                                <th>Total Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $sn = 1;
                            @endphp
                            @forelse ($expenses as $expense)
                                <tr>
                                    <td>{{$sn++}}</td>
                                    <td>{{$expense->expense_date}}</td>
                                    <td>{{$expense->accounting_head_name}}</td>
                                    <td>{{round($expense->total_amount)}}</td>
                                </tr>
                            @empty
                                
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <script src="{{ asset('js/report-actions.js') }}"></script>
        <script>
            const exportExcelOptions = {
                url: '{{ route("accounting.expense.export-excel") }}',
                filename: 'expense',
                extraData: @json(request()->query()),
            };
            const exportPdfOptions = {
                url: '{{ route("accounting.expense.export-pdf") }}',
                filename: 'expense',
                extraData: @json(request()->query()),
            };
            const exportPrintOptions = {
                url: '{{ route("accounting.expense.export-print") }}',
                filename: 'expense',
                extraData: @json(request()->query()),
            };
        </script>
    @endpush
@endsection

