@extends('layouts.master')
@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'income-expense-headwise-report'])
    <div class="card mt-2">
        <div class="card-body">
            <form action="{{ route('accounting.income-expense.headwise-report') }}" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range"
                                    value="{{ request()->query('date_range') }}" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Income Expense Headwise Report</h6>
            <div class="d-flex justify-content-end">
                <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print"
                    onclick="printDiv('landscape')"><i class="fas fa-print"></i></a>
            </div>
        </div>
        <div class="row table_content">
            <div class="col-md-6">
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Income Head</th>
                            <th>Total Income</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($incomes as $income)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $income->accounting_head_name }}</td>
                                <td>{{ $income->total_amount }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Expense Head</th>
                            <th>Total Expense</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($expenses as $expense)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $expense->accounting_head_name }}</td>
                                <td>{{ $expense->total_amount }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
