@extends('layouts.master')
@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'income-expense-summary'])
    <div class="card mt-2">
        <div class="card-body">
            <form action="{{ route('accounting.income-expense.summary') }}" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range" value="{{request()->query('date_range')}}" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Expense Report</h6>
            <div class="d-flex justify-content-end">
                <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print" onclick="printDiv()"><i class="fas fa-print"></i></a>
            </div>
        </div>
        <hr>
        <div class="row table_content">
            <div class="col-md-12">
                <div class="row p-3">
                    <div class="col-md-4">
                        <div class="card" style="border-left: 4px solid var(--blue);">
                            <div class="card-body">
                                <div class="align-items-center">
                                    <div style="margin: -10px;">
                                        <div class="text-sm font-weight-bold text-uppercase">Total Income : {{ number_format(round($totalIncome), 0) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card" style="border-left: 4px solid var(--blue);">
                            <div class="card-body">
                                <div class="align-items-center">
                                    <div style="margin: -10px;">
                                        <div class="text-sm font-weight-bold text-uppercase">Total Expense : {{ number_format(round($totalExpense), 0) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card" style="border-left: 4px solid var(--blue);">
                            <div class="card-body">
                                <div class="align-items-center">
                                    <div style="margin: -10px;">
                                        <div class="text-sm font-weight-bold text-uppercase">Total Revenue : {{ number_format(round($totalIncome - $totalExpense), 0) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row p-3">
                    <div class="col-md-6">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Total Income</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($incomes['incomes'] as $key => $income)
                                <tr>
                                    <td>{{ ++$key  }}</td>
                                    <td>{{ $income->income_date }}</td>
                                    <td>{{ $income->total_amount }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Total Expense</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($expenses['expenses'] as $key => $expense)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td>{{ $expense->expense_date }}</td>
                                    <td>{{ $expense->total_amount }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @push('scripts')
        <script>

        </script>
    @endpush
@endsection

