@extends('layouts.master')

@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'payment-details-report'])
    <div class="card mt-4">
        <div class="card-body card__head">
            <form action="{{ route('accounting.payment-details.report') }}" method="GET">

                <div class="row">
                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        @component('components.search_student', [
                            'student_name' => $student_name ?? '',
                            'student_id_no' => request()->student_id_no ?? '',
                            'required' => '',
                        ])
                        @endcomponent
                    </div>
                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        {{ generateDropdown($studentClasses, 'class="form-control form-control-sm student_class select2" id="student_class" name="student_class"', request()->query('student_class'), 'Select Class') }}
                    </div>

                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), 'Select Section') }}
                    </div>
                    {{-- <div class="form-group col-lg-3 col-md-6 col-sm-6">
                        {{ generateDropdown($academicYears, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Select Class") }}
                    </div> --}}

                    <div class="form-group col-lg-4 col-xl-3 col-xxl-2 col-md-6 col-6">
                        <button class="btn btn-sm btn-info">Search</button>
                    </div>
                </div>

            </form>
        </div>
    </div>
    <div class="card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Payment Details Report</h6>
            <div>
                <x-report-actions
                    :print="true"
                    :export_excel="true"
                    :export_pdf="true"
                />
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table_content table-bordered" id="dataTable">
                        <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Student ID</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Fees Category</th>
                            <th>Due Date</th>
                            <th>Paid Date</th>
                            <th>Total Amount</th>
                            <th>Paid Amount</th>
                            <th>Due Amount</th>
                            <th>Status</th>
                        </tr>
                        </thead>

                        <tbody>
                        @php
                            $sn = 1;
                        @endphp
                        @forelse ($paymentDetails as $payment)
                            <tr>
                                <td>{{ $sn++ }}</td>
                                <td>{{ $payment->student_id_no }}</td>
                                <td>{{ $payment->name }}</td>
                                <td>{{ $payment->class_name }}</td>
                                <td>{{ $payment->section_name ?? '--' }}</td>
                                <td>{{ $payment->title }}</td>
                                <td>{{ lastDateOfMonth($payment->month) }}</td>
                                <td>{{ $payment->payment_date ?? '' }}</td>
                                <td>{{ round($payment->assigned_fee) }}</td>
                                <td>{{ round($payment->paid_fee) }}</td>
                                <td>{{ round($payment->due_fee) }}</td>
                                <td>
                                    @if ($payment->paid_fee>0 && $payment->due_fee==0)
                                        {!! getStatusBadge(Status::PAID) !!}
                                    @endif
                                    @if ($payment->paid_fee==0 && $payment->due_fee>0)
                                        {!! getStatusBadge(Status::DUE) !!}
                                    @endif
                                </td>
                            </tr>
                        @empty
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>
        $('.student_class').on('change', function () {
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        if (student_class_id != '') {
            getSection(student_class_id);
        }

        function getSection(student_class_id) {

            let section_id = "{{ request()->query('section') ?? '' }}";
            if (student_class_id) {
                $.get('{{ route('sections.list_by_class') }}', {
                    student_class_id: student_class_id
                }, function (response) {
                    let sections = response;
                    console.log(sections);
                    let option = '<option value="">Select Section</option>';
                    for (let i = 0; i < sections.length; i++) {
                        if (section_id == sections[i].id) {
                            option += '<option value=' + sections[i].id + ' selected>' + sections[i].section_name +
                                '</option>';
                        } else {
                            option += '<option value=' + sections[i].id + ' >' + sections[i].section_name +
                                '</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }

        const exportExcelOptions = {
            url: '{{ route("accounting.payment-details.export-excel") }}',
            filename: 'payment-details',
            extraData: @json(request()->query()),
        };

        const exportPdfOptions = {
            url: '{{ route("accounting.payment-details.export-pdf") }}',
            filename: 'payment-details',
            extraData: @json(request()->query()),
        };

        const exportPrintOptions = {
            url: '{{ route("accounting.payment-details.export-print") }}',
            extraData: @json(request()->query()),
        };
    </script>
@endpush
