@extends('layouts.master')
@section('content')
    @include('report.accounting.header-menu', ['active_header' => 'payroll-report'])
    <div class="card mt-2">
        <div class="card-body">
            <form action="{{ route('accounting.payroll.report') }}" method="GET">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="form-group col-lg-3 col-md-3 col-sm-6">
                                <input type="text" id="reportrange" name="date_range" value="{{request()->query('date_range')}}" class="form-control form-control-sm">
                            </div>
                            <div class="col-lg-2">
                                <button class="btn btn-sm btn-info">Search</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Expense Report</h6>
            <div class="d-flex justify-content-end">
                <a class="btn btn-secondary btn__export" id="print-btn" href="#" data-toggle="tooltip" title="Print" onclick="printDiv()"><i class="fas fa-print"></i></a>
            </div>
        </div>
        <div class="row table_content">
            <div class="col-md-12">
          
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead class="thead-light">
                            <tr>
                                <th>Emp. Code</th>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Grade</th>
                                <th>Processed Date</th>
                                @foreach ($salary_heads as $head)
                                    <th>{{ $head->title }}</th>
                                @endforeach
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($newSalaries as $salary)
                                <tr>
                                    <td>{{ $salary->employee->employee_code }}</td>
                                    <td>{{ $salary->employee->name }}</td>
                                    <td>{{ $salary->employee->mobile_number ?? '-' }}</td>
                                    <td>{{ $salary->employee->salaryGrade->title ?? '-' }}</td>
                                    <td>{{ \Carbon\Carbon::parse($salary->process_date)->format('d-m-Y') }}</td>
                                    @foreach ($salary->salaryGrade->salaryGradeRules as $gradeRule)
                                        @if ($gradeRule->rule_type == 'Percentage')
                                            <td>{{ ($salary->amount * $gradeRule->amount)/100 }}</td>
                                        @else
                                            <td>{{ $salary->amount }}</td>
                                        @endif
                                    @endforeach
                                    <td>{!! getStatusBadge($salary->status) !!}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="100%" class="text-center">No data found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
        </div>
    </div>
    @push('scripts')
        <script>

        </script>
    @endpush
@endsection

