<table>
    <thead>
        <tr>
            <th colspan="{{ count($columns) + (in_array('SL', $columns) ? 1 : 0) }}" style="font-weight: bold; font-size: 14px; text-align: center; white-space: pre-wrap;">
                {{ $institute_name ?? 'N/A' }}
            </th> 
        </tr>
        <tr>
            <th colspan="{{ count($columns) + (in_array('SL', $columns) ? 1 : 0) }}" style="text-align: center;">
                {{ $report_title ?? 'N/A' }} (Class: {{ $class_name }}) (Shift: {{ $shift_name }})  (Date: {{ $form_date ?? 'N/A' }} To {{ $to_date ?? 'N/A' }}) 
            </th> 
        </tr>
        <tr>
            @foreach($columns as $column)
                @if($column == 'student_id')
                <th>Student ID</th>
                @elseif($column == 'roll')
                <th>Roll</th>
                @elseif($column == 'student_name')
                <th>Name</th>
                @elseif($column == 'total_present')
                <th>Total Present</th>
                @elseif($column == 'total_absent')
                <th>Total Absent</th>
                @elseif($column == 'total_late')
                <th>Total Late</th>
                @elseif($column == 'total_days')
                <th>Total Days</th>
                @endif
            @endforeach
        </tr>
    </thead>
    <tbody>
        @foreach($attendances as $attendance)
            <tr>
                @foreach($columns as $column)
                    @if($column == 'student_id')
                        <td>{{ $attendance->StudentInfo->student_id_no ?? 'N/A' }}</td>
                    @elseif($column == 'roll')
                        <td>{{ $attendance->StudentInfo->class_roll ?? 'N/A' }}</td>
                    @elseif($column == 'student_name')
                        <td>{{ $attendance->StudentInfo->first_name ?? 'N/A' }} {{ $attendance->StudentInfo->last_name ?? 'N/A' }}</td>
                    @elseif($column == 'total_present')    
                        <td>{{ $attendance->total_present ?? 'N/A' }}</td>
                    @elseif($column == 'total_absent')    
                        <td>{{ $attendance->total_absent ?? 'N/A' }}</td>
                    @elseif($column == 'total_late')    
                        <td>{{ $attendance->total_late ?? 'N/A' }}</td>
                    @elseif($column == 'total_days')    
                        <td>
                            @php
                                $totalDays = ($attendance->total_present ?? 0) 
                                            + ($attendance->total_absent ?? 0) 
                                            + ($attendance->total_late ?? 0);
                            @endphp
                            {{ $totalDays }}
                        </td>       
                    @endif
                @endforeach
            </tr>
        @endforeach
    </tbody>
</table>