<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $report_title ?? 'Report' }}</title>
    <style>
    .center{
        text-align: center;
    }
    .left{
        text-align: left;
    }
    .right{
        text-align: right;
    }
    .header {
        padding: 10px;
        text-align: center;
    }
    .header img{
        width: auto;
        height: 50px;
        padding: .25rem !important;
        filter: invert(1);
        opacity: .7;
    }
    .header .institute-name{
        padding: 0;
        margin: 0;
    } 
    .header p{
        margin: 0;
        padding: 0;
    }
    .main-table{
        width: 100%;
    }
    .main-table thead{
        background-color:#eaecf4;
        color: black;
        width: 100%;
    }
    .download-date{
        text-align: left;
        font-size: 15px;
        padding-top: 10px;
    }
    .main-table thead tr th{
        text-transform: capitalize;
    }
    table.main-table {
       border-collapse: collapse;
    }
    table.main-table td,  table.main-table th {
        border: 1px solid #e3e6f0;
        font-size: 14px;
        text-align: center;
    }
    table.main-table thead tr th{
        margin-bottom: 5px;
        font-size: 14px;
    }
    table.main-table tbody tr td:last-child{
        text-transform: capitalize;
    }

</style>

</head>
<body>
    <div class="card">
        <div class="header">
                @php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
                    $branch_info = get_branch_info();
                @endphp
                <img src="{{public_path($logo_path)}}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2> 
            <p class="institute-name">{{ $branch_info->address ?? '' }}</p> 
            <p class="institute-name">{{ $branch_info->contact_info ?? '' }}</p>
            <p><strong>{{ $report_title ?? 'Report' }}</strong></p>
        </div>


        <table style="width: 100%; border: none;">
            <tbody>
                <tr>
                    <td style="text-align: left; border: none; width: 80%;"><strong>Class:</strong> {{ $class_name }} <strong>Shift:</strong> {{ $shift_name }} <strong>Date:</strong> {{ $form_date ?? '' }} <strong>To</strong> {{ $to_date ?? '' }}</td>
                    <td style="text-align: right; border: none; width: 20%;"><strong>Date:</strong> {{ date('d-m-Y') }}</td>
                </tr>
            </tbody>
        </table>

        <table class="main-table">
            <thead>
                <tr>
                    @foreach($columns as $column)
                        @if($column == 'student_id')
                        <th class="center">Student ID</th>
                        @elseif($column == 'roll')
                        <th class="center">Roll</th>
                        @elseif($column == 'student_name')
                        <th class="left">Name</th>
                        @elseif($column == 'total_present')
                        <th class="center">Total Present</th>
                        @elseif($column == 'total_absent')
                        <th class="center">Total Absent</th>
                        @elseif($column == 'total_late')
                        <th class="center">Total Late</th>
                        @elseif($column == 'total_days')
                        <th class="center">Total Days</th>
                        @endif
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($attendances as $attendance)
                    <tr>
                        @foreach($columns as $column)
                            @if($column == 'student_id')
                                <td class="center">{{ $attendance->StudentInfo->student_id_no ?? 'N/A' }}</td>
                            @elseif($column == 'roll')
                                <td class="center">{{ $attendance->StudentInfo->class_roll ?? 'N/A' }}</td>
                            @elseif($column == 'student_name')
                                <td class="left">{{ $attendance->StudentInfo->first_name ?? 'N/A' }} {{ $attendance->StudentInfo->last_name ?? 'N/A' }}</td>
                        	@elseif($column == 'total_present')    
                                <td class="center">{{ $attendance->total_present ?? 'N/A' }}</td>
                            @elseif($column == 'total_absent')    
                                <td class="center">{{ $attendance->total_absent ?? 'N/A' }}</td>
                            @elseif($column == 'total_late')    
                                <td class="center">{{ $attendance->total_late ?? 'N/A' }}</td>
                            @elseif($column == 'total_days')    
                                <td class="center">
		                            @php
		                                $totalDays = ($attendance->total_present ?? 0) 
		                                            + ($attendance->total_absent ?? 0) 
		                                            + ($attendance->total_late ?? 0);
		                            @endphp
		                            {{ $totalDays }}
		                        </td>       
                            @endif
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>   
</body>
</html>