<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $report_title ?? 'Report' }}</title>
    <style>
        .center{
            text-align: center;
        }
        .left{
            text-align: left;
        }
        .right{
            text-align: right;
        }
        .header {
            padding: 10px;
            text-align: center;
        }
        .header img{
            width: auto;
            height: 50px;
            padding: .25rem !important;
            filter: invert(1);
            opacity: .7;
        }
        .header .institute-name{
            padding: 0;
            margin: 0;
        } 
        .header p{
            margin: 0;
            padding: 0;
        }
        .main-table{
            width: 100%;
        }
        .main-table thead{
            background-color:#eaecf4;
            color: black;
            width: 100%;
        }
        .download-date{
            text-align: left;
            font-size: 15px;
            padding-top: 10px;
        }
        .main-table thead tr th{
            text-transform: capitalize;
        }
        table.main-table {
           border-collapse: collapse;
        }
        table.main-table td,  table.main-table th {
            border: 1px solid #e3e6f0;
            font-size: 14px;
            text-align: center;
        }
        table.main-table thead tr th{
            margin-bottom: 5px;
            font-size: 14px;
        }
        table.main-table tbody tr td:last-child{
            text-transform: capitalize;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="header">
                @php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
                    $branch_info = get_branch_info();
                @endphp
                <img src="{{public_path($logo_path)}}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2> 
            <p class="institute-name">{{ $branch_info->address ?? '' }}</p> 
            <p class="institute-name">{{ $branch_info->contact_info ?? '' }}</p>
            <p><strong>{{ $report_title ?? 'Report' }}</strong></p>
        </div>


        <table style="width: 100%; border: none;">
            <tbody>
                <tr>
                    <td style="text-align: left; border: none; width: 80%;"> <strong>Filter By:</strong> {{ $filter_date ?? '' }}</td>
                    <td style="text-align: right; border: none; width: 20%;"><strong>Date:</strong> {{ date('d-m-Y') }}</td>
                </tr>
            </tbody>
        </table>

        <table class="main-table">
            <thead>
                <tr>
                    @foreach($columns as $column)
                        @if($column == 'class_name')
                        <th class="center">Class</th>
                        @elseif($column == 'shift_name')
                        <th class="center">Shift</th>
                        @elseif($column == 'total_student')
                        <th class="center">Total Student</th>
                        @elseif($column == 'total_present')
                        <th class="center">Total Present</th>
                        @elseif($column == 'total_absent')
                        <th class="center">Total Absent</th>
                        @elseif($column == 'total_late')
                        <th class="center">Total Late</th>
                        @endif
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($classAttendance as $attendance)
                    <tr>
                        @foreach($columns as $column)
                            @if($column == 'class_name')
                                <td class="center">{{ $attendance->class_name?? 'N/A' }}</td>
                            @elseif($column == 'shift_name')
                                <td class="center">{{ $attendance->shift_name ?? 'N/A' }}</td>
                            @elseif($column == 'total_student')
                                <td class="center">{{ $attendance->total_student ?? 'N/A' }}</td>
                            @elseif($column == 'total_present')
                                <td class="center">{{ $attendance->total_present?? 'N/A' }}</td>
                        	@elseif($column == 'total_absent')    
                                <td class="center">{{ $attendance->total_absent ?? 'N/A' }}</td>
                            @elseif($column == 'total_late')    
                                <td class="center">{{ $attendance->total_late ?? 'N/A' }}</td>     
                            @endif
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>   
</body>
</html>