@extends('layouts.master')
@section('content')
    @include('report.exam-result.header-menu', ['active_header' => 'class-gpa-report'])
    <div class="card mt-4">
        <div class="card-body card__head">
            <form method="GET" action="{{ route('exam-result.class-gpa.report') }}" class="row">
                <div class="col-md-6">
                    <div class="row">
                        <div class="form-group col-lg-4 col-md-12 col-sm-12">
                            {{ generateDropdown($exams, 'class="form-control exam_id" id="exam_id" name="exam_id" required', request()->query('exam_id'), 'Exam') }}
                        </div>

                        <div class="form-group col-lg-4 col-md-6 col-sm-6">
                            {{ generateDropdown($academicYears, 'name="academic_year" class="form-control academic_year" id="academic_year" required', request()->query('academic_year') ?? $defaultYear, 'Year') }}
                        </div>

                        <div class="form-group col-lg-4 col-md-6 col-sm-6">
                            {{ generateDropdown($shifts, 'class="form-control shift_id" id="shift_id" name="shift_id" ', request()->query('shift_id'), 'Shift') }}
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="row">
                        <div class="form-group col-lg-3 col-md-6 col-sm-6">
                            {{ generateDropdown($studentClasses, 'class="form-control select2 student_class" id="student_class" name="student_class_id" required', request()->query('student_class_id'), 'Class') }}
                        </div>

                        <div class="form-group col-lg-3 col-md-6 col-sm-6">
                            {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id" ', request()->query('section_id'), 'Section') }}
                        </div>

                        <div class="form-group col-lg-3 col-md-6 col-sm-6">
                            {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', request()->query('group_id'), 'Group') }}
                        </div>
                        <div class="form-group col-lg-3 col-md-6 col-sm-6">
                            <button type="submit" class="btn btn-info">Search</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-4" id="print-layout">
        <div class="row pt-2">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table-strip">
                        <thead class="thead-light">
                            <tr>
                                <th>Student ID</th>
                                <th>Name</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Roll</th>
                                <th class="bg-gray">Full <br> Marks</th>
                                <th>Total Obt.</th>
                                <th>Obt. Percentage</th>
                                <th>GPA</th>
                                <th>Grade</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($students && $students->isNotEmpty())
                                @php
                                    $head_marks_array = json_decode($assignedMarksHead->first(), true);
                                    $head_id_array = array_keys($head_marks_array);
                                    $subject_head_marks = $assignedMarksHead;
                                    $students_with_grand_total = [];
    
                                    foreach ($students as $student) {
                                        $grand_total_obtain = 0;
                                        $examRecords = $student->examRecords ?? collect();
    
                                        foreach ($examRecords as $record) {
                                            $head_wise_marks_record = json_decode($record->head_wise_marks);
                                            $head_marks_data = $subject_head_marks[$record->subject->id];
                                            $head_marks_array = json_decode($head_marks_data);
                                            $total_marks_obtain = 0;
    
                                            foreach ($markHeads as $head) {
                                                if (in_array($head->id, $head_id_array)) {
                                                    $total_marks_obtain += $head_wise_marks_record->{$head->id} ?? 0;
                                                }
                                            }
    
                                            $grand_total_obtain += $total_marks_obtain;
                                        }
    
                                        $students_with_grand_total[] = [
                                            'student' => $student,
                                            'grand_total_obtain' => $grand_total_obtain
                                        ];
                                    }
                                @endphp
    
                                @foreach ($students_with_grand_total as $data)
                                    @php
                                        $student = $data['student'];
                                        $grand_total_obtain = $data['grand_total_obtain'];
                                        $examRecords = $student->examRecords ?? collect();
                                        $section = $sections[$student->section_id] ?? '';
                                        $class = $studentClasses[$student->student_class_id] ?? '';
                                        $academic_year = request()->query('academic_year') ?? $defaultYear;
                                        $academicYear = $academicYears[$academic_year] ?? '';
                                        $grand_total = 0;
                                        $fail_count = 0; // Initialize fail_count if needed
                                    @endphp
    
                                    @if ($examRecords->isNotEmpty())
                                        @foreach ($examRecords as $record)
                                            @php
                                                $full_marks = 0;
                                                $head_wise_marks_record = json_decode($record->head_wise_marks);
                                                $head_marks_data = $subject_head_marks[$record->subject->id];
                                                $head_marks_array = json_decode($head_marks_data);
    
                                                foreach ($markHeads as $head) if (in_array($head->id, $head_id_array)) {
                                                    $full_marks += $head_marks_array->{$head->id} ?? 0;
                                                    $total_marks_obtain += $head_wise_marks_record->{$head->id} ?? 0;
                                                }
                                            
    
                                                $grand_total += $full_marks;
                                            @endphp
                                        @endforeach
                                    @endif
    
                                    <tr>
                                        <td>{{ $student->student_id_no }}</td>
                                        <td>{{ $student->first_name }}</td>
                                        <td>{{ $class }}</td>
                                        <td>{{ $section }}</td>
                                        <td>{{ $student->class_roll }}</td>
                                        <td class="bg-gray"><b>{{ $grand_total }}</b></td>
                                        <td><b>{{ $grand_total_obtain }}</b></td>
    
                                        @php
                                            $grand_total_percentage = $grand_total > 0 ? round(($grand_total_obtain * 100) / $grand_total) : 0;
                                            $grade = $grades->firstWhere(function($grade) use ($grand_total_percentage) {
                                                return $grade->mark_from <= $grand_total_percentage && $grade->mark_to >= $grand_total_percentage;
                                            });
                                        @endphp
    
                                        <td><b>{{ round($grand_total_percentage, 2) }}%</b></td>
                                        <td><b>{{ $grade->gpa ?? '-' }}</b></td>
                                        <td>
                                            <b>{{ $fail_count > 0 ? 'F' : ($grade->name ?? '-') }}</b>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="10">There is no data found</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $('.student_class').on('change', function(){
                let student_class_id = $('.student_class').val();
                getSection(student_class_id);
            });

            let student_class_id = "{{ request()->query('student_class_id') ?? '' }}";

            if(student_class_id!=''){
                getSection(student_class_id);
            }

            function getSection(student_class_id){

                let section_id = "{{ request()->query('section') ?? '' }}";
                if(student_class_id){
                    $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                        let sections = response;
                        console.log(sections);
                        let option = '<option value="">--Select Section--</option>';
                        for(let i=0;i<sections.length;i++){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                        }
                        console.log(option);
                        $('select.section_id').empty().append(option);
                    });
                }
            }
        </script>
    @endpush
@endsection

