<!DOCTYPE html>
<html>

<head>
    <style>
        .center {
            text-align: center;
        }

        .left {
            text-align: left;
        }

        .header {
            padding-top: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #ccc;
            text-align: center;
        }

        .header img {
            width: auto;
            height: 50px;
            padding: .25rem !important;
            filter: invert(1);
            opacity: .7;
        }

        .header .institute-name {
            padding: 0;
            margin: 0;
        }

        .header p {
            margin: 0;
            padding: 0;
        }

        .download-date {
            text-align: left;
            font-size: 15px;
            padding-top: 10px;
        }

        .main-table {
            width: 100%;
        }

        .main-table thead {
            background-color: #eaecf4;
            color: black;
            width: 100%;
        }

        .main-table thead tr th {
            text-transform: capitalize;
        }

        table.main-table {
            border-collapse: collapse;
        }

        table.main-table td,
        table.main-table th {
            border: 1px solid #e3e6f0;
            font-size: 14px;
            padding-left: 2px;
        }

        table.main-table thead tr th {
            margin-bottom: 5px;
            font-size: 14px;
        }

        table.main-table tbody tr td:last-child {
            text-transform: capitalize;
        }
    </style>
</head>

<body>
    <div class="card">
        @php
            extract($data, EXTR_SKIP)
        @endphp

        <div class="header">
            @php
                $logo_path = get_setting_value(Settings::EXPORT_LOGO)
                    ? get_setting_value(Settings::EXPORT_LOGO)
                    : 'uploads/images/logo.png';
                $institute_name = get_setting_value(Settings::SCHOOL_NAME)
                    ? get_setting_value(Settings::SCHOOL_NAME)
                    : '';
            @endphp
            <img src="{{ asset($logo_path) }}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2>
            <p><strong>{{ $title ?? 'Report' }}</strong></p>
            {!! $subtitle ?? '' !!}
            <div class="download-date">
                Requisition Date: {{ date('d-m-Y') }}
            </div>
        </div>
    
        
        <table class="main-table">
            <thead>
                <tr>
                    <th>Student ID</th>
                    <th>Name</th>
                    <th>Class</th>
                    <th>Section</th>
                    <th>Roll</th>
                    <th>Position</th>
                    <th class="bg-gray">Full <br> Marks</th>
                    <th>Total Obt.</th>
                    <th>Obt. Percentage</th>
                    <th>Highest Marks</th>
                    <th>GPA</th>
                    <th>Grade</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @if ($students)
                    @php
                    
                        $head_marks_array = json_decode($assignedMarksHead->first(), true);
                        $head_id_array = array_keys($head_marks_array);
                        $subject_head_marks = $assignedMarksHead;
                        $highest_grand_total_obtain = 0;
    
                        // Calculate grand total obtained for each student
                        $students_with_grand_total = [];
    
                        foreach ($students as $student) {
                            $grand_total_obtain = 0;
                            $examRecords = $student?->examRecords ?? '';
    
                            if ($examRecords->isNotEmpty()) {
                                foreach ($examRecords as $record) {
                                    $head_wise_marks_record = json_decode($record->head_wise_marks);
                                    $head_marks_data = $subject_head_marks[$record->subject->id];
                                    $head_marks_array = json_decode($head_marks_data);
                                    $total_marks_obtain = 0;
    
                                    foreach ($markHeads as $head) {
                                        if (in_array($head->id, $head_id_array)) {
                                            $total_marks_obtain += $head_wise_marks_record?->{$head->id} ?? 0;
                                        }
                                    }
    
                                    $grand_total_obtain += $total_marks_obtain;
                                }
                            }
    
                            // Add student and their total obtained marks
                            $students_with_grand_total[] = [
                                'student' => $student,
                                'grand_total_obtain' => $grand_total_obtain
                            ];
    
                            // Update highest total if this student's grand_total_obtain is higher
                            if ($grand_total_obtain > $highest_grand_total_obtain) {
                                $highest_grand_total_obtain = $grand_total_obtain;
                            }
                        }
    
                        // Sort students by grand_total_obtain in descending order
                        usort($students_with_grand_total, function ($a, $b) {
                            return $b['grand_total_obtain'] <=> $a['grand_total_obtain'];
                        });
    
                        $position = 1; // To assign position based on sorted order
                    @endphp
                    @foreach ($students_with_grand_total as $data)
                        @php
                            $student = $data['student'];
                            $grand_total_obtain = $data['grand_total_obtain'];
                            $grand_total = 0;
                            $fail_count = 0;
                            $examRecords = $student?->examRecords ?? '';
                            $section = $sections[$student->section_id] ?? '';
                            $class = $studentClasses[$student->student_class_id] ?? '';
                            $academic_year = request()->query('academic_year') ?? $defaultYear;
                            $academicYear = $academicYears[$academic_year] ?? '';
                        @endphp

                        @if ($examRecords->isNotEmpty())
                            @foreach ($examRecords as $record)
                                @php
                                    $full_marks = 0;
                                    $head_wise_total_obtain = [];
                                    $total_marks_obtain = 0;

                                    $head_wise_marks_record = json_decode($record->head_wise_marks);
                                    $head_marks_data = $subject_head_marks[$record->subject->id];
                                    $head_marks_array = json_decode($head_marks_data);
                                @endphp

                                @if (isset($head_wise_marks_record))
                                    @foreach ($markHeads as $head)
                                        @if (in_array($head->id, $head_id_array))
                                            @php
                                                $full_marks += $head_marks_array->{$head?->id};
                                                $total_marks_obtain += $head_wise_marks_record?->{$head?->id} ?? 0;
                                            @endphp
                                        @endif
                                    @endforeach

                                    @php
                                        $grand_total += $full_marks;
                                    @endphp
                                @endif
                            @endforeach
                        @endif

                        <tr>
                            <td>{{ $student->student_id_no }}</td>
                            <td>{{ $student->name }}</td>
                            <td>{{ $class }}</td>
                            <td>{{ $section ?? '--' }}</td>
                            <td>{{ $student->class_roll }}</td>
                            <td>{{ $position++ }}</td>
                            <td class="bg-gray"><b>{{ $grand_total }}</b></td>
                            <td><b>{{ $grand_total_obtain }}</b></td>
                            @php
                                $grade_name = '';
                                $grade_point = '';
                                $grade_name_remarks = '';
                                $grand_total_percentage = $grand_total_obtain > 0 && $grand_total > 0
                                    ? round(($grand_total_obtain * 100) / $grand_total)
                                    : 0;
                                foreach ($grades as $grade) {
                                    if ($grade->mark_from <= $grand_total_percentage && $grade->mark_to >= $grand_total_percentage) {
                                        $grade_name = $grade->name;
                                        $grade_point = $grade;
                                        $grade_name_remarks = $grade->remark;
                                        if($grade_name=='F'){
                                            $fail_count++;
                                        }
                                    }
                                }
                            @endphp
                            <td><b>{{ round($grand_total_percentage, 2) }}%</b></td>
                            <td class="highest-grand-total"></td>
                            <td><b>{{ $grade_point->gpa }}</b></td>
                            <td>
                                @if ($fail_count > 0)
                                    <b>F</b>
                                @else
                                    <b>{{ $grade_name }}</b>
                                @endif
                            </td>
                            <td>
                                @if ($fail_count > 0)
                                    Fail
                                @else
                                Pass
                                @endif
                            
                            </td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td class="text-center" colspan="8">There is no data found</td>
                    </tr>
                @endif

            </tbody>
        </table>

        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var highestGrandTotalObtain = {{ $highest_grand_total_obtain ?? 0 }};
            var elements = document.querySelectorAll('.highest-grand-total');
            elements.forEach(function(element) {
                element.innerHTML = '<b>' + highestGrandTotalObtain + '</b>';
            });
        });
    </script>
</body>

</html>

