@php
$head_marks_array = json_decode($assignedMarksHead->first(), true);
$head_id_array = array_keys($head_marks_array);
$subject_head_marks = $assignedMarksHead;
$highest_grand_total_obtain = 0;

$passedStudents = [];
$failedStudents = [];

foreach ($students as $student) {

    $grand_total_obtain = 0;
    $fail_count = 0;

    $examRecords = $student->examRecords ?? collect();

    if ($examRecords->isNotEmpty()) {

        foreach ($examRecords as $record) {

            // convert obtained marks to array (IMPORTANT FIX)
            $head_wise_marks_record = json_decode($record->head_wise_marks, true);

            // convert full marks to array
            $head_marks_array = json_decode($subject_head_marks[$record->subject->id], true);

            $total_marks_obtain = 0;
            $subject_failed = false;

            foreach ($markHeads as $head) {

                // skip if head not used
                if (!isset($head_marks_array[$head->id])) {
                    continue;
                }

                $full_mark = $head_marks_array[$head->id];

                if ($full_mark == null || $full_mark == 0 || !is_numeric($full_mark)) {
                    continue;
                }

                // FIXED: get obtained from ARRAY (not object)
                $obtained = $head_wise_marks_record[$head->id] ?? 0;

                // add to total
                $total_marks_obtain += $obtained;

                // individual pass mark
                $pass_mark = round($full_mark * 0.33);

                // FAIL if this head failed
                if ($obtained < $pass_mark) {
                    $subject_failed = true;
                }
            }


            $grand_total_obtain += $total_marks_obtain;

            if ($subject_failed) {
                $fail_count++;
            }
        }



                dd($head_marks_array ,$head ,$head_wise_marks_record,   $full_mark );
    }

    // store
    $studentData = [
        'student' => $student,
        'grand_total_obtain' => $grand_total_obtain,
        'fail_count' => $fail_count
    ];

    if ($fail_count > 0) {
        $failedStudents[] = $studentData;
    } else {
        $passedStudents[] = $studentData;
    }
}

// sorting
usort($failedStudents, function ($a, $b) {
    return ($b['grand_total_obtain'] <=> $a['grand_total_obtain'])
        ?: ($a['fail_count'] <=> $b['fail_count']);
});

usort($passedStudents, function ($a, $b) {
    return ($b['grand_total_obtain'] <=> $a['grand_total_obtain'])
        ?: ($a['fail_count'] <=> $b['fail_count']);
});

$students_with_grand_total = array_merge($passedStudents, $failedStudents);
$position = 1;
@endphp

============================================================

@php
$head_marks_array = json_decode($assignedMarksHead->first(), true);
$head_id_array = array_keys($head_marks_array);

$subject_head_marks = $assignedMarksHead;
$highest_grand_total_obtain = 0;

$passedStudents = [];
$failedStudents = [];

foreach ($students as $student) {

    $grand_total_obtain = 0;
    $fail_count = 0;

    $examRecords = $student?->examRecords ?? '';

    if ($examRecords->isNotEmpty()) {
        foreach ($examRecords as $record) {

            $head_wise_marks_record = json_decode($record->head_wise_marks);
            $head_marks_data = $subject_head_marks[$record->subject->id];
            $head_marks_array = json_decode($head_marks_data);

            $total_marks_obtain = 0;
            foreach ($markHeads as $head) {
                if (in_array($head->id, $head_id_array)) {
                    $total_marks_obtain += $head_wise_marks_record?->{$head->id} ?? 0;
                }
            }


            $grand_total_obtain += $total_marks_obtain;



            // Check FAIL in this subject
            $full_marks = array_sum((array) $head_marks_array);
            $percentage = $full_marks > 0 ? round(($total_marks_obtain * 100) / $full_marks) : 0;

            foreach ($grades as $grade) {
                if ($percentage >= $grade->mark_from && $percentage <= $grade->mark_to) {
                    if ($grade->name == 'F') $fail_count++;
                }
            }
        }

            dd($student->student_id_no, $student->id, $total_marks_obtain, $grand_total_obtain, $head_marks_array );
    }

    $studentData = [
        'student' => $student,
        'grand_total_obtain' => $grand_total_obtain,
        'fail_count' => $fail_count
    ];

    if ($fail_count > 0) {
        $failedStudents[] = $studentData;
    } else {
        $passedStudents[] = $studentData;
    }
}
// Sort FAILED students
usort($failedStudents, function ($a, $b) {
    // Sort by marks DESC
    if ($a['grand_total_obtain'] !== $b['grand_total_obtain']) {
        return $b['grand_total_obtain'] <=> $a['grand_total_obtain'];
    }

    // Sort by fail count ASC
    return $a['fail_count'] <=> $b['fail_count'];
});

// Sort PASSED students
usort($passedStudents, function ($a, $b) {
    // Sort by marks DESC
    if ($a['grand_total_obtain'] !== $b['grand_total_obtain']) {
        return $b['grand_total_obtain'] <=> $a['grand_total_obtain'];
    }

    // Sort by fail count ASC
    return $a['fail_count'] <=> $b['fail_count'];
});



// Merge results
$students_with_grand_total = array_merge($passedStudents, $failedStudents);

$position = 1;
@endphp



















===============================





@extends('layouts.master')
@section('content')
    @include('report.exam-result.header-menu', ['active_header' => 'class-rank-report'])
    <div class="card mt-4">
        <div class="card-body card__head">
            <form method="GET" action="{{ route('exam-result.class-rank.report') }}" class="row">

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                        <option value="">Exam</option>
                        @foreach ($exams as $examItem)
                            <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first)) >
                                {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    <select name="shift_id" class="form-control select2 shift_id" id="shift_id" >
                        <option value="">Shift</option>
                        @foreach ($shifts as $shift)
                            <option value="{{ $shift->id }}" @selected($shift_id == $shift->id || (!$shift_id && $loop->first))>
                                {{ $shift->shift_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control select2 student_class_id student_class" id="student_class" name="student_class_id" required', request()->query('student_class_id'), 'Class') }}
                </div>

                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    {{ generateDropdown([], 'class="form-control section_id" id="section_id" name="section_id" ', request()->query('section_id'), 'Section') }}
                </div>

                <x-group-selector
    name="group_id"
    label=""
    labelText="Group"
    col="form-group col-lg-2 col-md-6 col-sm-6"
    :student_class_id="(int) request()->input('student_class')"
    :required="(int) request()->input('student_class') >= 11"
    :selected="old('group_id') ?? request()->input('group_id')"
/>


                {{-- <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    {{ generateDropdown($groups, 'class="form-control group_id" id="group_id" name="group_id"', request()->query('group_id'), 'Group') }}
                </div> --}}
                <div class="form-group col-lg-2 col-md-6 col-sm-6">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>

            </form>
        </div>
    </div>

    @if($students)
        <div class="card mt-4" id="print-layout">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                <h6 class="m-0 table__top__txt">{{ $title }}</h6>
                <div class="m-0 float-right">
                    <x-report-actions
                        :export_pdf="true"
                        :print="true"
                    />
                    <a class="btn btn-secondary btn__export mr-1" title="All Mark Sheet Download" target="_blank" href="{{ route('all-mark-sheet-download',['student_class_id'=> $student_class_id, 'exam_id'=> $exam_id, 'shift_id'=> $shift_id, 'section_id'=> $section_id, 'group_id'=> $group_id ]) }}">
                        All Mark Sheet
                    </a>
                </div>
            </div>
            <div class="row pt-2">
                <div class="col-md-12">
                    <div class="table-responsive table_content">
                        <table class="table table-strip">
                            <thead class="thead-light">
                                <tr>
                                    <th>Roll</th>
                                    <th>Std. ID</th>
                                    <th>Name</th>
                                    <th>Position</th>
                                    <th>Class</th>
                                    <th>Section</th>
                                    <th class="bg-gray">Full <br> Marks</th>
                                    <th>Total Obt.</th>
                                    <th>Obt. Percentage</th>
                                    <th>Highest Marks</th>
                                    <th>GPA</th>
                                    <th>Grade</th>
                                    <th>Status</th>
                                    <th>Download</th>
                                </tr>
                            </thead>

                            <tbody>
                                @php
                                    $head_marks_array = json_decode($assignedMarksHead->first(), true);
                                    $head_id_array = array_keys($head_marks_array);

                                    $subject_head_marks = $assignedMarksHead;
                                    $highest_grand_total_obtain = 0;

                                    // Calculate grand total obtained for each student
                                    $students_with_grand_total = [];

                                    foreach ($students as $student) {
                                        $grand_total_obtain = 0;
                                        $examRecords = $student?->examRecords ?? '';

                                        if ($examRecords->isNotEmpty()) {
                                            foreach ($examRecords as $record) {
                                                $head_wise_marks_record = json_decode($record->head_wise_marks);
                                                $head_marks_data = $subject_head_marks[$record->subject->id];
                                                $head_marks_array = json_decode($head_marks_data);
                                                $total_marks_obtain = 0;

                                                foreach ($markHeads as $head) {
                                                    if (in_array($head->id, $head_id_array)) {
                                                        $total_marks_obtain += $head_wise_marks_record?->{$head->id} ?? 0;
                                                    }
                                                }

                                                $grand_total_obtain += $total_marks_obtain;
                                            }
                                        }
                                        // Add student and their total obtained marks
                                        $students_with_grand_total[] = [
                                            'student' => $student,
                                            'grand_total_obtain' => $grand_total_obtain
                                        ];

                                        // Update highest total if this student's grand_total_obtain is higher
                                        if ($grand_total_obtain > $highest_grand_total_obtain) {
                                            $highest_grand_total_obtain = $grand_total_obtain;
                                        }
                                    }

                                    // Sort students by grand_total_obtain in descending order
                                    usort($students_with_grand_total, function ($a, $b) {
                                        return $b['grand_total_obtain'] <=> $a['grand_total_obtain'];
                                    });

                                    $position = 1; // To assign position based on sorted order
                                @endphp

                                @foreach ($students_with_grand_total as $data)
                                    @php
                                        $student = $data['student'];
                                        $grand_total_obtain = $data['grand_total_obtain'];
                                        $grand_total = 0;
                                        $fail_count = 0;
                                        $examRecords = $student?->examRecords ?? '';
                                        $section = $sections[$student->section_id] ?? '';
                                        $class = $studentClasses[$student->student_class_id] ?? '';
                                        $academic_year = request()->query('academic_year') ?? $defaultYear;
                                        $academicYear = $academicYears[$academic_year] ?? '';

                                    @endphp

                                    @if ($examRecords->isNotEmpty())


                                        @foreach ($subjects_assigns as $subjects_assign)
                                            @php
                                                $full_marks = 0;
                                                $head_wise_total_obtain = [];
                                                $total_marks_obtain = 0;

                                                $subject_id = $subjects_assign->subject_id;
                                                $recoards = $examRecords->firstWhere('subject_id', $subject_id);

                                                $head_wise_marks_record = $recoards ? json_decode($recoards->head_wise_marks) : null;
                                                $head_marks_data = $subject_head_marks[$subject_id] ?? '{}';
                                                $head_marks_array = json_decode($head_marks_data);

                                                // Skip this subject if all head-wise marks are null
                                                $all_marks_null = true;
                                                if ($head_wise_marks_record) {
                                                    foreach ($head_id_array as $head_id) {
                                                        if (isset($head_wise_marks_record->{$head_id}) && $head_wise_marks_record->{$head_id} !== null) {
                                                            $all_marks_null = false;
                                                            break;
                                                        }
                                                    }
                                                }
                                                if ($all_marks_null) {
                                                    continue;
                                                }
                                            @endphp

                                            @if ($head_wise_marks_record)
                                                @foreach ($markHeads as $head)
                                                    @if (in_array($head->id, $head_id_array))
                                                        @php
                                                            $full_marks += $head_marks_array->{$head?->id} ?? 0;
                                                            $total_marks_obtain += $head_wise_marks_record->{$head?->id} ?? 0;
                                                            $head_wise_grand_total[$head?->id] =
                                                                ($head_wise_grand_total[$head?->id] ?? 0) +
                                                                ($head_wise_marks_record->{$head?->id} ?? 0);
                                                        @endphp
                                                    @endif
                                                @endforeach

                                                @php
                                                    $grand_total += $full_marks;
                                                @endphp
                                            @else
                                                @php
                                                    $full_marks = 0;
                                                    foreach ($markHeads as $head) {
                                                        if (in_array($head->id, $head_id_array)) {
                                                            $full_marks += $head_marks_array->{$head->id} ?? 0;
                                                        }
                                                    }
                                                    $grand_total += $full_marks;
                                                @endphp
                                            @endif

                                            @php
                                                $subject_grade_name = '';
                                                $total_percentage = ($total_marks_obtain > 0 && $full_marks > 0)
                                                    ? round((($total_marks_obtain * 100) / $full_marks))
                                                    : 0;

                                                foreach ($grades as $grade) {
                                                    if ($grade->mark_from <= $total_percentage && $grade->mark_to >= $total_percentage) {
                                                        $subject_grade_name = $grade->name;
                                                        if ($subject_grade_name == 'F') {
                                                            $fail_count++;
                                                        }
                                                    }
                                                }
                                            @endphp
                                        @endforeach

                                    @endif

                                    <tr>
                                        <td>{{ $student->class_roll }}</td>
                                        <td>{{ $student->student_id_no }}</td>
                                        <td>{{ $student->name }}</td>
                                        <td>{{ $position++ }}</td>
                                        <td>{{ $class }}</td>
                                        <td>{{ $section ?? '--' }}</td>
                                        <td class="bg-gray"><b>{{ $grand_total }}</b></td>
                                        <td><b>{{ $grand_total_obtain }}</b></td>
                                        @php
                                            $grade_name = '';
                                            $grade_point = '';
                                            $grade_name_remarks = '';
                                            $grand_total_percentage = $grand_total_obtain > 0 && $grand_total > 0
                                                ? round(($grand_total_obtain * 100) / $grand_total)
                                                : 0;
                                            foreach ($grades as $grade) {
                                                if ($grade->mark_from <= $grand_total_percentage && $grade->mark_to >= $grand_total_percentage) {
                                                    $grade_name = $grade->name;
                                                    $grade_point = $grade;
                                                    $grade_name_remarks = $grade->remark;
                                                    if($grade_name=='F'){
                                                        $fail_count++;
                                                    }
                                                }
                                            }
                                        @endphp
                                        <td><b>{{ round($grand_total_percentage, 2) }}%</b></td>
                                        <td class="highest-grand-total"></td>
                                        <td><b>{{ $grade_point->gpa ?? '' }}</b></td>
                                        <td>
                                            @if ($fail_count > 0)
                                                <b>F</b>
                                            @else
                                                <b>{{ $grade_name }}</b>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($fail_count > 0)
                                                <span class="badge " style="border: 1px solid rgb(255, 99, 99); font-size: 13px; color: rgb(255, 99, 99); padding: 8px; border-radius: 1px; width: 100px;">
                                                    <i class="fas fa-exclamation-triangle"></i> Fail
                                                </span>
                                            @else
                                                <span class="badge " style="border: 1px solid #0abb75;font-size: 14px;color: var(--white);padding: 8px !important;border-radius: 1px;width: 100px;background: #0abb75;">
                                                    <i class="far fa-check-circle"></i> Pass
                                                </span>
                                            @endif

                                        </td>
                                        <td>
                                            <a target="_blank" href="{{ route('individule-mark-sheet-download',['student_id'=> $student->student_id_no, 'student_class_id'=> $student->student_class_id, 'exam_id'=> $exam_id, 'shift_id'=> $shift_id, 'section_id'=> $student->section_id ]) }}">
                                                <span class="badge " style="border: 1px solid var(--light-blue-active);font-size: 14px;color: #377dff;padding: 8px !important;border-radius: 1px;background: rgba(55, 125, 255, .15);">
                                                    <i class="fa fa-arrow-down" aria-hidden="true" style="margin-right: 6px;"></i>
                                                Download
                                                </span>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @else

        @if (isset($students) && empty($students))
            <div class="card mt-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-bottom">
                    <h6 class="m-0 table__top__txt">Result Report (Total Result: 0)</h6>
                    <div class="m-0 float-right">
                        <button class="btn btn-sm btn-primary">Print</button>
                    </div>
                </div>
                <div class=" table_content">
                    <section class="page-section">
                        <div class="table-responsive">
                            <table class="table" width="100%">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Roll</th>
                                        <th>Std. ID</th>
                                        <th>Name</th>
                                        <th>Position</th>
                                        <th>Position</th>
                                        <th>Class</th>
                                        <th>Section</th>
                                        <th class="bg-gray">Full <br> Marks</th>
                                        <th>Total Obt.</th>
                                        <th>Obt. Percentage</th>
                                        <th>Highest Marks</th>
                                        <th>GPA</th>
                                        <th>Grade</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr><td colspan="20" class="text-center">No data available in table</td></tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="page-break"></div>
                    </section>
                </div>
            </div>
        @endif
    @endif

    @push('scripts')
        <script src="{{ asset('js/report-actions.js') }}"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                var highestGrandTotalObtain = {{ $highest_grand_total_obtain ?? 0 }};
                var elements = document.querySelectorAll('.highest-grand-total');
                elements.forEach(function(element) {
                    element.innerHTML = '<b>' + highestGrandTotalObtain + '</b>';
                });
            });

            $('.student_class').on('change', function(){
                let student_class_id = $('.student_class').val();
                getSection(student_class_id);
            });

            let student_class_id = "{{ request()->query('student_class_id') ?? '' }}";

            if(student_class_id!=''){
                getSection(student_class_id);
            }

            function getSection(student_class_id){

                let section_id = "{{ request()->query('section_id') ?? '' }}";
                if(student_class_id){
                    $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                        let sections = response;
                        let option = '<option value="">Section</option>';
                        for(let i=0;i<sections.length;i++){
                            if(section_id==sections[i].id){
                                option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                            }else{
                                option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                            }
                        }
                        $('select.section_id').empty().append(option);
                    });
                }
            }

            const exportPrintOptions = {
                url: '{{ route("exam-result.class-rank.print") }}',
                filename: 'class-rank-report',
                extraData: @json(request()->query()),
            };

            const exportPdfOptions = {
                url: '{{ route("exam-result.class-rank.pdf") }}',
                filename: 'class-rank-report',
                extraData: @json(request()->query()),
            };
        </script>
    @endpush
@endsection

