<table>
    <thead>

    @php
        $branch_info = get_branch_info();
    @endphp
    <tr>
        <th colspan="{{ count($columns) }}" style="font-weight: bold; font-size: 14px; text-align: center;">
            {{ $institute_name ?? 'N/A' }}
        </th>
    </tr>
    <tr>
        <th colspan="{{ count($columns) }}" style="text-align: center;">
            {{ $report_name ?? 'N/A' }} (Address: {{ $branch_info->address ?? '' }}) (Contact
            No: {{ $branch_info->contact_info ?? '' }}) (Hostel: {{ $hostel_name }})
        </th>
    </tr>
    <tr>
        @foreach($columns as $column)
            <th>
                @switch($column)
                    @case('student_name') Student Name @break
                    @case('student_id') Student ID @break
                    @case('hostel_room_id') Room No @break
                    @case('guardian_contact') Guardian Contact @break
                    @case('room_type_id') Room Type @break
                    @case('cost') Cost Per Bed @break
                    @default {{ ucwords(str_replace('_', ' ', $column)) }}
                @endswitch
            </th>
        @endforeach
    </tr>
    </thead>
    <tbody>
    @foreach($hostels as $hostel)
        <tr>
            @foreach($columns as $column)
                <td>
                    @switch($column)
                        @case('student_name')
                        {{ $hostel->studentInfo->name ?? 'N/A' }}
                        @break
                        @case('student_id')
                        {{ $hostel->studentInfo->student_id_no ?? 'N/A' }}
                        @break
                        @case('hostel_room_id')
                        {{ $hostel->hostelRoom->room_name ?? 'N/A' }}
                        @break
                        @case('guardian_contact')
                        {{ $hostel->studentInfo->guardian_mobile ?? 'N/A' }}
                        @break
                        @case('room_type_id')
                        {{ $hostel->hostelRoom->roomType->name ?? 'N/A' }}
                        @break
                        @case('cost')
                        {{ $hostel->cost ?? 'N/A' }}
                        @break
                        @default
                        {{ $hostel->{$column} ?? 'N/A' }}
                    @endswitch
                </td>
            @endforeach
        </tr>
    @endforeach
    </tbody>
</table>
