<table>
    <thead>
        <tr>
            <th colspan="{{ count($columns) + (in_array('SL', $columns) ? 1 : 0) }}" style="text-align: center;">
                @foreach($subjects as $subject)
                {{$subject}}
                @endforeach
            </th> 
        </tr>
        <tr>
            @foreach ($columns as $column)
                @if($column == 'booklist_id')
                <th>Book Title</th>
                @elseif($column == 'book_number')
                <th>Book Number</th>
                @elseif($column == 'issue_date')
                <th>Issue Date</th>
                @elseif($column == 'estimate_return_date')
                <th>ERD</th>
                @elseif($column == 'return_date')
                <th>Return Date</th>
                @elseif($column == 'created_by')
                <th>Issue By</th>
                @elseif($column == 'user_id')
                <th>Member Type</th>
                @endif
            @endforeach
        </tr>
    </thead>
    <tbody>
        @foreach ($bookissues as $issue)
            <tr>
                @foreach($columns as $column)
                    @if($column == 'booklist_id' && $issue->{$column})
                        <td>{{ $issue->booklist->title ?? 'N/A' }}</td>
                    @elseif($column == 'book_number')
                        <td>{{ $issue->booklist->book_number ?? 'N/A' }}</td>
                    @elseif($column == 'issue_date' && $issue->{$column})
                        <td>{{ $issue->issue_date ?? 'N/A' }}</td>  
                    @elseif($column == 'estimate_return_date' && $issue->{$column})
                        <td>{{ $issue->estimate_return_date ?? 'N/A' }}</td>    
                    @elseif($column == 'return_date' && $issue->{$column})
                        <td>{{ $issue->return_date ?? 'N/A' }}</td>         
                    @elseif($column == 'created_by' && $issue->{$column})
                        <td>{{ $issue->issueBy->name }}</td>
                    @elseif($column == 'user_id' && $issue->{$column})
                        <td>{{ $issue->user->user_type }}</td>   
                    @endif
                @endforeach
            </tr>
        @endforeach
    </tbody>
</table>