<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $subject ?? 'Report' }}</title>
    <style>
    .center{
        text-align: center;
    }
    .left{
        text-align: left;
    }
    .header {
        padding: 10px;
        border-bottom: 1px solid #ccc;
        text-align: center;
    }
    .header img{
        width: auto;
        height: 50px;
        padding: .25rem !important;
        filter: invert(1);
        opacity: .7;
    }
    .header .institute-name{
        padding: 0;
        margin: 0;
    } 
    .header p{
        margin: 0;
        padding: 0;
    }
    .main-table{
        width: 100%;
    }
    .main-table thead{
        background-color:#eaecf4;
        color: black;
        width: 100%;
    }
    .main-table thead tr th{
        text-transform: capitalize;
    }
    table.main-table {
       border-collapse: collapse;
    }
    table.main-table td,  table.main-table th {
        border: 1px solid #e3e6f0;
        font-size: 14px;
        text-align: center;
    }
    table.main-table thead tr th{
        margin-bottom: 5px;
        font-size: 14px;
    }
    table.main-table tbody tr td:last-child{
        text-transform: capitalize;
    }

</style>
</head>
<body>
    <div class="card">
        <div class="header">
                @php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
                @endphp
                <img src="{{public_path($logo_path)}}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2> 
            <p><strong>{{ $subject ?? 'Report' }}</strong></p>
        </div>
        <table class="main-table">
            <thead>
                <tr>
                    @foreach($columns as $column)
                        @if($column == 'booklist_id')
                        <th>Book Title</th>
                        @elseif($column == 'book_number')
                        <th>Book Number</th>
                        @elseif($column == 'issue_date')
                        <th>Issue Date</th>
                        @elseif($column == 'estimate_return_date')
                        <th>ERD</th>
                        @elseif($column == 'return_date')
                        <th>Return Date</th>
                        @elseif($column == 'created_by')
                        <th>Issue By</th>
                        @elseif($column == 'user_id')
                        <th>Member Type</th>
                        @endif
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($bookissues as $issue)
                    <tr>
                        @foreach($columns as $column)
                            @if($column == 'booklist_id' && $issue->{$column})
                                <td>{{ $issue->booklist->title ?? 'N/A' }}</td>
                            @elseif($column == 'book_number')
                                <td>{{ $issue->booklist->book_number ?? 'N/A' }}</td>
                            @elseif($column == 'issue_date' && $issue->{$column})
                                <td>{{ $issue->issue_date ?? 'N/A' }}</td>  
                            @elseif($column == 'estimate_return_date' && $issue->{$column})
                                <td>{{ $issue->estimate_return_date ?? 'N/A' }}</td>    
                            @elseif($column == 'return_date' && $issue->{$column})
                                <td>{{ $issue->return_date ?? 'N/A' }}</td>         
                            @elseif($column == 'created_by' && $issue->{$column})
                                <td>{{ $issue->issueBy->name }}</td>
                            @elseif($column == 'user_id' && $issue->{$column})
                                <td>{{ $issue->user->user_type }}</td>   
                            @endif
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>   
</body>
</html>