@extends('layouts.master')

@section('content')

<div class="card mt-4 d-print-none">
    <div class="card-header py-3 card__head">
        <form action="{{ route('multi-branch.income-report') }}" method="get">
            <div class="form-row align-items-center">
                <!-- Date Input and Search Button -->
                <div class="col-lg-6 col-md-8">
                    <div class="form-row">
                        <div class="col-sm-6 mb-2 mb-sm-0">
                            <div class="form-group">
                                <input type="text" id="reportrange" name="date" 
                                    value="{{ old('date') ?? request('date') }}" 
                                    class="form-control" placeholder="Select Date">
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <button id="search" onclick="viewTable()" class="btn btn-info mt-2">Search</button>
                        </div>
                    </div>
                </div>

                <!-- Go Back Button -->
                <div class="col-lg-6 col-md-4 text-md-right">
                    <a href="{{ route('multi-branch.report') }}" class="btn btn-info btn-md">Go Back</a>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-header d-flex justify-content-between align-items-center d-print-none">
        <h5 class="card-title">Income Report</h5>
        <div>
            <x-report-actions 
                :print="true"
            />
        </div>
    </div>
    <div class="row pt-2 print-layout" id="print-layout">
        <div class="col-md-12">
            <x-custom-print-header />

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Branch</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($incomes as $income)
                        <tr>
                            <td>{{ $income->branch_name }}</td>
                            <td>{{ $income->total_amount }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection