@extends('layouts.master')
@section('content')
    <div class="pg__admin mt-4">
        <div class="row">
            <div class="col-md-12">
                <div class="text-center mb-4">
                     <h5 class="mb-1 font-weight-bold">Report at a glance</h5>
{{--                    <p class="mb-0">Here you can see a summary of all branches. You can also see branch wise summary by clicking on the cards below.</p>--}}
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xl-2 col-md-6 col-6">
                <x-at-a-glance-card
                    title="Total collection"
                    value="{{ $total_collection ?? 0 }} tk"
                    trendClass="{{ $total_collection < 0 ? 'text-danger' : 'text-success' }}"
                    trendIcon="{{ $total_collection > 0 ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                    trendText="Last 30 days data"
                    borderColor="var(--success)"
                    icon="fas fa-database"
                    iconColor="{{ $total_collection > 0 ? 'text-success' : 'text-danger' }}"
                    bgColor="#fff"
                    {{-- href="{{ route('multi-branch.total-collection') }}" --}}
                />
            </div>
            <div class="col-xl-2 col-md-6 col-6">
            <x-at-a-glance-card
                title="Total income"
                value="{{ $total_income ?? 0 }} tk"
                trendClass="{{ $total_income < 0 ? 'text-danger' : 'text-success' }}"
                trendIcon="{{ $total_income > 0 ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                trendText="Last 30 days data"
                borderColor="var(--success)"
                icon="fas fa-database"
                iconColor="text-success"
                {{-- href="{{ route('multi-branch.income-report') }}" --}}
            />
            </div>
            <div class="col-xl-2 col-md-6 col-6">
            <x-at-a-glance-card
                title="Total expense"
                value="{{ $total_expense ?? 0 }} tk"
                trendClass="{{ $total_expense < 0 ? 'text-danger' : 'text-success' }}"
                trendIcon="{{ $total_expense > 0 ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                trendText="Last 30 days data"
                borderColor="var(--success)"
                icon="fas fa-database"
                iconColor="text-success"
                {{-- href="{{ route('multi-branch.expense-report') }}" --}}
            />
            </div>
            <div class="col-xl-2 col-md-6 col-6">
            <x-at-a-glance-card
                title="Total students"
                value="{{ $total_students ?? 0 }}"
                trendClass="{{ $total_students < 0 ? 'text-danger' : 'text-success' }}"
                trendIcon="{{ $total_students > 0 ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                trendText="Till now"
                borderColor="var(--success)"
                icon="fas fa-database"
                iconColor="text-success"
                {{-- href="{{ route('multi-branch.students') }}" --}}
            />
            </div>
            <div class="col-xl-2 col-md-6 col-6">
            <x-at-a-glance-card
                title="Total teachers"
                value="{{ $total_teachers ?? 0 }}"
                trendClass="{{ $total_teachers < 0 ? 'text-danger' : 'text-success' }}"
                trendIcon="{{ $total_teachers > 0 ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                trendText="Till now"
                borderColor="var(--success)"
                icon="fas fa-database"
                iconColor="text-success"
                {{-- href="{{ route('multi-branch.teachers') }}" --}}
            />
            </div>
            <div class="col-xl-2 col-md-6 col-6">
            <x-at-a-glance-card
                title="Total employees"
                value="{{ $total_employees ?? 0 }}"
                trendClass="{{ $total_employees < 0 ? 'text-danger' : 'text-success' }}"
                trendIcon="{{ $total_employees > 0 ? 'fa fa-arrow-up' : 'fa fa-arrow-down' }}"
                trendText="Till now"
                borderColor="var(--success)"
                icon="fas fa-database"
                iconColor="text-success"
                {{-- href="{{ route('multi-branch.employees') }}" --}}
            />
            </div>


        </div>

        <div class="row mb-5 card__style__2">
            @foreach ($branches as $branch)
                <div class="col-md-12">
                    <div class="text-center mb-4">
                        <h5 class="mb-1 mt-5 font-weight-bold">{{ $branch->branch_name ?? '' }} Branch</h5>
                    </div>
                </div>
                <x-branch-income-card :branch-id="$branch->id" />
                <x-branch-expense-card :branch-id="$branch->id" />
                <x-branch-student-card :branch-id="$branch->id" />
                <x-branch-teacher-card :branch-id="$branch->id" />
                <x-branch-employee-card :branch-id="$branch->id" />
                <x-branch-admission-card :branch-id="$branch->id" />
            @endforeach
        </div>
    </div>
@endsection
