@extends('layouts.master')
@section('content')
    @include('report.students.header-menu', ['active_header' => 'class-section-report'])
    <div class="card mt-4" id="print-layout">
        <div class="card-header py-3 card__head d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Class Section Report</h6>
            <x-report-actions :print="true" :exportPdf="true" />
        </div>
        <div class="row">
            <div class="col-md-12">

                <div class="table-responsive">
                    <table class="table table-strip" id="studentsTable">
                        <thead class="thead-light">
                            <tr>
                                <th>SN</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Shift</th>
                                <th>Total Student</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $sn = 1;
                            @endphp
                            @foreach ($students as $student)
                                <tr>
                                    <td>{{$sn++}}</td>
                                    <td>{{ $student->studentClass->class_name }}</td>
                                    <td>{{ $student->section->section_name }}</td>
                                    <td>{{ $student->shift?->shift_name ?? '--' }}</td>
                                    <td>{{ $student->students_count }}</td>
                                    <td>
                                        <a class="btn btn-sm btn-soft-success" href="{{ route('student_info.index', [
                                            'student_id_no' => '',
                                            'shift' => '',
                                            'group' => '',
                                            'student_class' => $student->student_class_id,
                                            'section' => $student->section_id
                                        ]) }}" target="_blank">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>
        const exportPdfOptions = {
            url: '{{ route("students.class-section.export-pdf") }}',
            filename: 'class-section-report',
            extraData: @json(request()->query()),
        };

        const exportPrintOptions = {
            url: '{{ route("students.class-section.export-print") }}',
            filename: 'class-section-report',
            extraData: @json(request()->query()),
        };
    </script>
@endsection