@extends('layouts.master')
@section('content')
    @include('report.students.header-menu', ['active_header' => 'information-report'])
    <div class="card mt-4" id="print-layout">
        <div class="card-header py-3 card__head">
            <form method="GET" action="{{ route('students.information.report') }}" class="row">
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class" required', request()->query('student_class'), "Class") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($departments, 'class="form-control department" id="department" name="department"', request()->query('department'), "Department") }}
                </div>
                {{-- <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($academicYears, 'class="form-control academic_year" id="academic_year" name="academic_year"', request()->query('academic_year') ?? $defaultYear, "Academic Year") }}
                </div> --}}
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($genderOptions, 'class="form-control" id="gender" name="gender"', request()->query('gender'), "Gender") }}
                </div>
                <div class="form-group col-lg-1">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Student Information</h6>
            <x-report-actions :columns="[
                'student_id_no' => 'Student ID',
                'profile_image' => 'Image',
                'name' => 'Name',
                'class_roll' => 'Roll',
                'branch.branch_name' => 'Branch',
                'student_class.class_name' => 'Class',
                'section.section_name' => 'Section',
                'shift.shift_name' => 'Shift',
                'father_name' => 'Father Name',
                'father_mobile' => 'Father Phone',
                'mother_name' => 'Mother Name',
                'mother_mobile' => 'Mother Phone',
                'guardian_name' => 'Guardian Name',
                'guardian_mobile' => 'Guardian Phone',
            ]" :print="true" :exportPdf="true" :exportExcel="true" />
        </div>

        <div class="row">
            <div class="col-md-12">
                
                <div class="table-responsive">
                    <table class="table table_content" id="studentsTable">
                        <thead class="thead-light">
                            <tr>
                                <th>Student ID</th>
                                <th>Image</th>
                                <th>Name</th>
                                <th>Roll</th>
                                <th>Branch</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Shift</th>
                                <th>Father Name</th>
                                <th>Father Phone</th>
                                <th>Mother Name</th>
                                <th>Mother Phone</th>
                                <th>Guardian Name</th>
                                <th>Guardian Phone</th>
                            </tr>
                        </thead>
                        <tbody>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
    </div>
@endsection

@section('scripts')
<script src="{{ asset('js/report-actions.js') }}"></script>
<script>
    $(document).ready(function() {
        $('.student_class').on('change', function(){
            let student_class_id = $('.student_class').val();
            getSection(student_class_id);
        });

        let student_class_id = "{{ request()->query('student_class') ?? '' }}";

        if(student_class_id!=''){
            getSection(student_class_id);
        }

        function getSection(student_class_id){

            let section_id = "{{ request()->query('section') ?? '' }}";
            if(student_class_id){
                $.get('{{ route('sections.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                    let sections = response;
                    let option = '<option value="">--Select Section--</option>';
                    for(let i=0;i<sections.length;i++){
                        if(section_id==sections[i].id){
                            option += '<option value='+sections[i].id+' selected>'+sections[i].section_name+'</option>';
                        }else{
                            option += '<option value='+sections[i].id+' >'+sections[i].section_name+'</option>';
                        }
                    }
                    $('select.section').empty().append(option);
                });
            }
        }
        let query = @json(request()->query());
        let table;
        const assetUrl = "{{ asset('') }}";
        if (Object.keys(query).length > 0) {
            table = $('#studentsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{!! route('students.information.report') !!}',
                    type: 'GET',
                    data: function(d) {
                        $.extend(d, query);
                    }
                },
                columns: [
                    { data: 'student_id_no', name: 'student_id_no', orderable: false, searchable: false },
                    {
                        data: 'profile_image',
                        name: 'profile_image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            let studentImage = row.profile_image ? row.profile_image : 'uploads/student/graduated_student.png';
                            return '<img src="' + assetUrl + studentImage + '" class="rounded-circle border p-1" alt="" height="40px" width="40px">';
                        }
                    },
                    { data: 'name', name: 'name' },
                    { data: 'class_roll', name: 'class_roll' },
                    { data: 'branch.branch_name', name: 'branch.branch_name' },
                    { data: 'student_class.class_name', name: 'student_class.class_name' },
                    {
                        data: 'section.section_name',
                        name: 'section.section_name',
                        render: function(data, type, row) {
                            return row.section ? row.section.section_name : '--';
                        }
                    },
                    { 
                        data: 'shift.shift_name', name: 'shift.shift_name',
                        render: function(data, type, row) {
                            return row.shift ? row.shift.shift_name : '--';
                        }
                    },
                    { data: 'father_name', name: 'father_name' },
                    { data: 'father_mobile', name: 'father_mobile' },
                    { data: 'mother_name', name: 'mother_name' },
                    { data: 'mother_mobile', name: 'mother_mobile' },
                    { data: 'guardian_name', name: 'guardian_name' },
                    { data: 'guardian_mobile', name: 'guardian_mobile' },
                ],
                language: {
                    emptyTable: "No data available in table",
                    zeroRecords: "No matching records found",
                    processing: "<span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span> Loading..."
                }
            });

            // Initialize column toggle after table is created
            initializeColumnToggle(table, {
                'student_id_no': 0,
                'profile_image': 1,
                'name': 2,
                'class_roll': 3,
                'branch.branch_name': 4,
                'student_class.class_name': 5,
                'section.section_name': 6,
                'shift.shift_name': 7,
                'father_name': 8,
                'father_mobile': 9,
                'mother_name': 10,
                'mother_mobile': 11,
                'guardian_name': 12,
                'guardian_mobile': 13
            });
        }
    });

    const exportExcelOptions = {
        url: '{{ route("students.information.export-excel") }}',
        filename: 'student-information',
        extraData: @json(request()->query()),
    };
    
    const exportPdfOptions = {
        url: '{{ route("students.information.export-pdf") }}',
        filename: 'student-information',
        extraData: @json(request()->query()),
    };

    const exportPrintOptions = {
        url: '{{ route("students.information.export-print") }}',
        extraData: @json(request()->query()),
    };
</script>
@endsection
