@extends('layouts.master')
@section('content')
    @include('report.students.header-menu', ['active_header' => 'student-sibling-report'])
    <div class="card mt-2">
        <div class="card-header py-3 card__head">
            <form method="GET" action="{{ route('student-sibling.report') }}" class="row">
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($shifts, 'class="form-control shift" id="shift" name="shift"', request()->query('shift'), "Shift") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class"', request()->query('student_class'), "Class") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown([], 'class="form-control section" id="section" name="section"', request()->query('section'), "Section") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($groups, 'class="form-control group" id="group" name="group"', request()->query('group'), "Group") }}
                </div>
                <div class="form-group col-lg-2 col-md-4 col-sm-6">
                    {{ generateDropdown($academicYears, 'class="form-control academic_year" id="academic_year" name="academic_year"', request()->query('academic_year') ?? $defaultYear, "Academic Year") }}
                </div>
                <div class="form-group col-lg-1">
                    <button type="submit" class="btn btn-info">Search</button>
                </div>
            </form>
        </div>
    </div>
    <div class="card mt-3" id="print-layout">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="table__top__txt">Sibling Report</h6>
            <x-report-actions :columns="[
                'student_id_no' => 'Student ID',
                'name' => 'Name',
                'class_roll' => 'Roll',
                'mobile_no' => 'Phone Number',
                'father_name' => 'Father Name',
                'mother_name' => 'Mother Name',
                'all_siblings' => 'Siblings'
            ]" :print="true" :exportPdf="true" />
        </div>
        <div class="row">
            <div class="col-md-12">
          
                <div class="table-responsive">
                    <table class="table table-strip" id="dataTable">
                        <thead class="thead-light">
                            <tr>
                                <th>ID No</th>
                                <th>Name</th>
                                <th>Roll</th>
                                <th>Phone Number</th>
                                <th>Father Name</th>
                                <th>Mother Name</th>
                                <th>Siblings</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($students as $student)
                                <tr>
                                    <td>{{$student->class_roll}}</td>
                                    <td>{{$student->student_id_no}}</td>
                                    <td>{{$student->name}}</td>
                                    <td>{{$student->mobile_no}}</td>
                                    <td>{{$student->father_name}}</td>
                                    <td>{{$student->mother_name}}</td>
                                    <td class="text-nowrap">
                                        @if($student->all_siblings->isNotEmpty())
                                            <ul style="margin-left: -25px;">
                                                @foreach($student?->all_siblings as $sibling)
                                                    <li class="">{{ trim($sibling->name) }}</li>
                                                @endforeach
                                            </ul>
                                        @else
                                            <span>No Siblings</span>
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="{{ asset('js/report-actions.js') }}"></script>
    <script>
        const exportPdfOptions = {
            url: '{{ route("students.sibling.export-pdf") }}',
            filename: 'sibling-report',
            extraData: @json(request()->query()),
        };

        const exportPrintOptions = {
            url: '{{ route("students.sibling.export-print") }}',
            extraData: @json(request()->query()),
        };
    </script>
@endsection