<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $report_title ?? 'Report' }}</title>
    <style>
    .center{
        text-align: center;
    }
    .left{
        text-align: left;
    }
    .header {
        padding: 10px;
        border-bottom: 1px solid #ccc;
        text-align: center;
    }
    .header img{
        width: auto;
        height: 50px;
        padding: .25rem !important;
        filter: invert(1);
        opacity: .7;
    }
    .header .institute-name{
        padding: 0;
        margin: 0;
    } 
    .header p{
        margin: 0;
        padding: 0;
    }
    /*    /new css*/
    body {
        font-family: Arial, sans-serif;
        font-size: 12px;
    }
    table {
        width: 100%;
        border-collapse: collapse;
    }
    table tbody tr{
        border: 1px solid #ddd;
    }
    th, td {
        padding: 8px;
        text-align: left;
    }
    th {
        background-color: #f4f4f4;
        font-weight: bold;
    }
    .header2{
        background-color: #e9e9e9;
        padding: .75rem;
        border-bottom: 1px solid #ccc;
    }
    .subject-header {
        font-size: 14px;
        font-weight: bold;
    }
    .lesson-name {
        font-style: italic;
    }
    .text-black {
        color: black;
    }
    .text-secondary {
        color: gray;
    }
    ul {
        padding-left: 0;
        list-style: none;
    }
    ul.topic{
        padding-left: 10px;
    }
    ul li h6{
        padding-left: 7px;
    }
    ul li ul {
        padding-left: 21px;
        list-style: none;
    }
</style>
</head>
<body>
    <div class="card">
        <div class="header">
                @php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
                    $branch_info = get_branch_info();
                @endphp
                <img src="{{public_path($logo_path)}}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2> 
            <p class="institute-name">{{ $branch_info->address ?? '' }}</p> 
            <p class="institute-name">{{ $branch_info->contact_info ?? '' }}</p>
            <p><strong>{{ $report_title ?? 'Report' }}</strong></p>
        </div>
        <div class="header2">
            <strong>Exam:</strong> {{ $exam_name ?? '' }} &nbsp;&nbsp;&nbsp;
            <strong>Class:</strong> {{ $class_name ?? '' }}
        </div>
        <table>
            <thead>
                <tr>
                    <th>Lesson Topic</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $displayedSubjects = [];
                @endphp
                @forelse($lessons as $lessonKey => $lesson)
                    @if(!in_array($lesson->subject->id, $displayedSubjects))
                        @php
                            $displayedSubjects[] = $lesson->subject->id;
                        @endphp
                        <tr>
                            <td colspan="2" class="subject-header">{{ $lesson->subject->subject_name }}</td>
                        </tr>
                    @endif
                    <tr>
                        <td>
                            <strong>{{ $lessonKey + 1 }}. {{ $lesson->name }}</strong>
                            <ul class="topic">
                                @if($lesson->lessonTopics->isNotEmpty())
                                    @foreach($lesson->lessonTopics as $topicKey => $topic)
                                        <li>
                                            {{ $lessonKey + 1 }}.{{ $topicKey + 1 }} {{ $topic->name }}
                                        </li>
                                    @endforeach
                                @else
                                    <em>No topics available</em>
                                @endif
                            </ul>
                        </td>
                        <td>
                            <ul>
                                @if($lesson->lessonTopics->isNotEmpty())
                                    @foreach($lesson->lessonTopics as $topic)
                                        <li>
                                            @if($topic->status)
                                                <span class="text-black">Completed ({{ $topic->completed_date }})</span>
                                            @else
                                                <span class="text-secondary">Incomplete</span>
                                            @endif
                                        </li>
                                    @endforeach
                                @endif
                            </ul>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="2" class="text-center">No data available in table</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>   
</body>
</html>