@extends('layouts.master')
@section('styles')
<style>
    .list-unstyled li .lesson-name{
        padding-left: 7px;
    }
    .list-unstyled li ul {
        padding-left: 21px;
        list-style: none;
    }
</style>
@endsection
@section('content')
@include('report.syllabus.header-menu', ['active_header' => 'syllabus-status-report'])
<div class="card mt-4">
    <div class="card-body card__head">
        <div class="row">
            <div class="col-md-10">
                <form method="POST" action="{{ route('syllabus.status.report.search') }}" class="row">
                    @csrf
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        {{ generateDropdown($exams, 'class="form-control exam_id select2" id="exam_id" name="exam_id" required', $exam_id, "Select Exam") }}
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        {{ generateDropdown($studentClasses, 'class="form-control student_class select2" id="student_class" name="student_class" required', $student_class_id, "Select Class") }}
                    </div>
                    <div class="form-group col-md-3 col-md-3 col-sm-6">
                        {{ generateDropdown('', 'class="form-control form-control-sm subject_id " id="subject_id" name="subject_id"', $subject_id, "All Subject") }}
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        <button id="search" class="btn btn-info">Search</button>
                    </div>
                </form>
            </div>
            <div class="col-md-2">
                <div class="m-0 float-right" id="column-panel-parent">
                    <a class="btn btn-secondary btn__export" id="pdf-btn" href="#" data-toggle="tooltip" title="Download as PDF">
                        <i class="fas fa-file-pdf"></i>
                    </a>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table" id="book-issue">
                    <thead class="thead-light">
                        @if(!empty($exam_name))
                        <tr class="hide" id="visible">
                            <td colspan="5" class="text-left">@if(!empty($exam_name)) <strong class="font-weight-bold">Exam:</strong> @endif {{ $exam_name ?? '' }}  @if(!empty($class_name)) <strong class="font-weight-bold">Class:</strong> {{ $class_name ?? '' }} @endif</td>
                        </tr>
                        @endif
                        <tr>
                            <th>
                                <div class="row">
                                    <div class="col-md-6 col-xs-7"> Lesson Topic</div>
                                    <div class="col-md-6 col-xs-5 pl-4">Status</div>
                                </div>    
                           </th>
                        </tr>
                    </thead>    
                    <tbody>
                        @if(!empty($lessons))
                        @if(count($lessons) > 0)
                            @php
                                $displayedSubjects = [];
                            @endphp
                            @foreach($lessons as $lessonKey=>$lesson)
                            <tr>
                                <td>
                                    @if(!in_array($lesson->subject->id, $displayedSubjects))
                                        @php
                                            $displayedSubjects[] = $lesson->subject->id;
                                        @endphp
                                        <h5>{{ $lesson->subject->subject_name }}</h5>
                                    @endif
                                    <ul class="list-unstyled">
                                        <li><h6>{{$lessonKey+1}} <span class="lesson-name">{{$lesson->name}}</span></h6>
                                        <ul>
                                            @if($lesson->lessonTopics->isNotEmpty())
                                            @foreach($lesson->lessonTopics as $topicKey=>$topic)
                                            <li>
                                                <div class="row">
                                                    <div class="col-md-6 col-xs-7"><span class="pr15">{{$lessonKey+1}}.{{$topicKey+1}}</span> {{$topic->name}}</div>
                                                   
                                                    <div class="col-md-6 col-xs-5">
                                                        @if($topic->status)
                                                        <span class="text-black">Completed({{$topic->completed_date}})</span>
                                                        @else
                                                        <span class="text-secondary">Incomplete</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </li>
                                            @endforeach
                                            @else
                                                <em>No topics available</em>
                                            @endif
                                        </ul>
                                        </li>
                                    </ul>
                                </td>        
                            </tr>
                             @endforeach
                        @else
                        <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif
                        @else
                        <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>
@stop

@section('scripts')
<script>
    $('#pdf-btn').on('click', function (e) {
        e.preventDefault();

        // Get values from filter fields
        let exam_id = $('#exam_id').val();
        let student_class_id = $('#student_class').val();
        let subject_id = $('#subject_id').val();

        $.ajax({
            url: '{{ route("syllabus.pdf.export") }}', // Route to handle PDF generation
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                'exam_id': exam_id,
                'student_class_id': student_class_id,
                'subject_id': subject_id,
            },
            xhrFields: {
                responseType: 'blob', // Important for downloading files
            },
            success: function (data, status, xhr) {
                // Ensure the response contains the expected PDF blob
                if (xhr.status === 200 && data.size > 0) {
                    // Create a URL for the file blob
                    const url = window.URL.createObjectURL(data);
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = 'syllabus-status-report.pdf'; // Set the file name
                    document.body.appendChild(a);
                    a.click();
                    a.remove();
                } else {
                    Swal.fire({
                        icon: 'warning', // You can change the icon (e.g., 'error', 'info', 'success')
                        title: 'Data Empty',
                        text: 'No content available to download!',
                        confirmButtonText: 'OK' // Customize the button text
                    });
                }
            },
            error: function (xhr, status, error) {
                console.error('Error exporting PDF:', xhr.responseText);
                alert('Error generating PDF');
            }
        });
    });


    // $('#pdf-btn').on('click', function (e) {
    //     e.preventDefault();
    //     // Get values from filter fields
    //     let exam_id = $('#exam_id').val();
    //     let student_class_id = $('#student_class').val();
    //     let subject_id = $('#subject_id').val();

    //     $.ajax({
    //         url: '{{ route("syllabus.pdf.export") }}', // Route to handle PDF generation
    //         method: 'POST',
    //         data: {
    //             _token: '{{ csrf_token() }}',
    //             'exam_id'   : exam_id,
    //             'student_class_id': student_class_id,
    //             'subject_id': subject_id,
    //         },
    //         xhrFields: {
    //             responseType: 'blob', // Important for downloading files
    //         },
    //         success: function (data) {
    //             console.log(data);
    //             // Create a URL for the file blob
    //             const url = window.URL.createObjectURL(new Blob([data]));
    //             const a = document.createElement('a');
    //             a.href = url;
    //             a.download = 'syllabus-status-report.pdf'; // Set the file name
    //             document.body.appendChild(a);
    //             a.click();
    //             a.remove();
    //         },
    //         error: function (xhr) {
    //             console.error('Error exporting PDF:', xhr.responseText);
    //         }
    //     });
    // });

    $('.student_class').on('change', function(){
        let student_class_id = $('.student_class').val();
        getSubjects(student_class_id);
    });
    $('.subject_id').on('change', function(){
        let student_class_id = $('.student_class').val();
        let subject_id = $('.subject_id').val();
    });

    let student_class_id = "{{ isset($student_class_id) ? $student_class_id : '' }}";
    let subject_id = "{{ isset($subject_id) ? $subject_id : '' }}";


    if(student_class_id!=''){
        getSubjects(student_class_id);
    }

    //------------------Get Class Wise Subject List----------------
    function getSubjects(student_class_id){
        if(student_class_id){
            $.get('{{ route('subjects.list_by_class') }}', { student_class_id: student_class_id }, function(response) {
                let subjects = response;

                let option = '<option value="">All Subject</option>';
                for(let i=0;i<subjects.length;i++){
                    if(subjects[i].student_class_id == student_class_id){
                        if(subject_id==subjects[i].subject_id){
                            option += '<option value='+subjects[i].subject_id+' selected>'+subjects[i].subject.subject_name+'</option>';
                        }else{
                            option += '<option value='+subjects[i].subject_id+' >'+subjects[i].subject.subject_name+'</option>';
                        }
                    }
                }
                $('select.subject_id').empty().append(option);
            });
        }
    }

</script>
@endsection
