@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 table__top__txt">Today's Attendance</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="table-responsive">
                    <table class="table table-strip table-bordered">
                        <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Shift</th>
                            <th>Class</th>
                            <th>Section</th>
                        </tr>
                        </thead>
                        <tbody>
                            @if ($attendances)
                                @foreach ($attendances as $student)
                                    <tr>
                                        <td>{{$student->StudentInfo->student_id_no ?? ''}}</td>
                                        <td>{{$student->StudentInfo->name ?? ''}}</td>
                                        <td>{{$student->StudentInfo->shift->shift_name ?? ''}}</td>
                                        <td>{{$student->StudentInfo->studentClass->class_name ?? ''}}</td>
                                        <td>{{$student->StudentInfo->section->name ?? ''}}</td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection