@extends('layouts.master')
@section('content')
@include('report.transport.header-menu', ['active_header' => 'transport-route-wise-student-report'])
<div class="card mt-4">
    <div class="card-header py-3  card__head">
        <div class="row">
            <div class="col-md-9">
                <div class="row">
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        {{ generateDropdown($transport_routes, 'class="form-control select2 route_id" id="route_id" name="route_id" required', '', "Select Route") }}
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        {{ generateDropdown([], 'class="form-control select2 stoppage_id" id="stoppage_id" name="stoppage_id" required', '', "Select Stoppage") }}
                    </div>
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        @component('components.search_student', [
                                        'student_name' => $student_name ?? '',
                                        'student_id_no' => $student_id_no ?? '',
                                        'required' => '',
                                    ])
                                    @endcomponent
                    </div>
		            {{-- <div class="form-group col-lg-3 col-md-3 col-sm-6">
		                {{ generateDropdown($transport_routes, 'class="form-control select2 route_id" id="route_id" name="route_id" required', '', "Select Route") }}
		            </div> --}}
                    <div class="form-group col-lg-3 col-md-3 col-sm-6">
                        <button id="search" onclick="viewTable()" class="btn btn-info">Search</button>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="m-0 float-right" id="column-panel-parent">
                    <a class="btn btn-secondary btn__export" href="#"  data-toggle="tooltip" title="Print" onclick="printTable()">
                        <i class="fas fa-print"></i>
                    </a>
                    <a class="btn btn-secondary btn__export" id="excel-btn" href="#" data-toggle="tooltip" title="Download as excel">
                        <i class="fas fa-file-excel"></i>
                    </a>
                    <a class="btn btn-secondary btn__export" id="pdf-btn" href="#" data-toggle="tooltip" title="Download as PDF">
                        <i class="fas fa-file-pdf"></i>
                    </a>
                    <a class="btn btn-secondary btn__export" href="#" data-toggle="collapse" data-target="#column-toggle-panel" title="Toggle column">
                        <i class="fas fa-columns"></i>
                    </a>
                    <div id="column-toggle-panel" class="collapse border rounded-bottom shadow">
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="student_name" id="student_name" checked style="display:none;">
                            <label class="column-form-check-label" for="student_name">Student Name</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="student_id" id="student_id" checked style="display:none;">
                            <label class="column-form-check-label" for="student_id">Student ID</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="student_class" id="student_class" checked style="display:none;">
                            <label class="column-form-check-label" for="student_class">Class (Section)</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="guardian_name" id="guardian_name" checked style="display:none;">
                            <label class="column-form-check-label" for="guardian_name">Guardian Name</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="guardian_contact" id="guardian_contact" checked style="display:none;">
                            <label class="column-form-check-label" for="guardian_contact">Guardian Contact</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="stoppage_id" id="stoppage_id" checked style="display:none;">
                            <label class="column-form-check-label" for="stoppage_id">Stoppage</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="toggle-column column-form-check-input" value="monthly_cost" id="monthly_cost" checked style="display:none;">
                            <label class="column-form-check-label" for="monthly_cost">Fee</label>
                        </div>
                       <button class="restorebutton">Restore Visibility</button>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="row">
        <div class="col-md-12">
            <div id="primary-info" class="pl-3 pt-3"></div>
            <div class="table-responsive">
                <table class="table pt-3" id="transport">
                    <thead class="thead-light">
                        <tr>
                            <th>Student Name</th>
                            <th>Student ID</th>
                            <th>Class (Section)</th>
                            <th>Guardian Name</th>
                            <th>Guardian Contact</th>
                            <th>Stoppage</th>
                            <th>Fee</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>
@stop

@section('scripts')
<script>

$('.route_id').on('change', function(){
    let route_id = $(this).val();
    let stoppage_id = '';
    getStoppage(route_id, stoppage_id);
});

let route_id = "{{ isset($route_id) ? $route_id : '' }}";
let stoppage_id = "{{ isset($stoppage_id) ? $stoppage_id : '' }}";

function getStoppage(route_id, stoppage_id){

    if(route_id){
        $.get('{{ route('stoppage-list-by-route') }}', { route_id: route_id }, function(response) {
            let stoppages = response;
            let option = '<option value="">Select Stoppage</option>';
            for(let i=0;i<stoppages.length;i++){
                if(stoppage_id==stoppages[i].id){
                    option += '<option value='+stoppages[i].id+' selected>'+stoppages[i].name+'</option>';
                }else{
                    option += '<option value='+stoppages[i].id+' >'+stoppages[i].name+'</option>';
                }
            }
            $('select.stoppage_id').empty().append(option);
        });
    }
}

$(document).ready(function() {
    $('#student_id_no').select2({
        placeholder: 'Search by ID or Mobile',
        minimumInputLength: 2,
        multiple: true, // Enable multiple selections
        closeOnSelect: false, // Prevent dropdown from closing after selection
        ajax: {
            url: '{{ route('students.search') }}', // Adjust the route
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    q: params.term // Search term
                };
            },
            processResults: function(data) {
                return {
                    results: data.map(function(item) {
                        return {
                            id: item.id,
                            text: `${item.first_name} ${item.last_name} (${item.student_id_no})`
                        };
                    })
                };
            },
            cache: true
        },
        escapeMarkup: function(markup) {
            return markup; // Allow custom HTML
        },
        templateResult: function(data) {
            if (!data.id) {
                return data.text;
            }

            // Add checkbox to each result with label click support
            const uniqueId = `checkbox-${data.id}`; // Unique ID for each checkbox
            return $(`
                <div class="form-check">
                    <input type="checkbox" id="${uniqueId}" class="form-check-input select2-checkbox" value="${data.id}">
                    <label for="${uniqueId}" class="form-check-label">${data.text}</label>
                </div>
            `);
        },
        templateSelection: function(data) {
            return data.text; // Format selected items
        }
    });

    // Function to update the selected item count
    function updateSelectedCount() {
        const selectedCount = $('#student_id_no').val()?.length || 0;
        $('#selected-count').text(`Selected Items: ${selectedCount}`);
    }

    // Sync checkboxes with selections
    $('#student_id_no').on('select2:open', function() {
        // Sync checkboxes with current selected values
        const selectedValues = $('#student_id_no').val() || [];
        $('.select2-checkbox').each(function() {
            const checkboxValue = $(this).val();
            $(this).prop('checked', selectedValues.includes(checkboxValue));
        });
    });

    // Handle checkbox click events
    $(document).on('change', '.select2-checkbox', function() {
        const selectedValues = $('#student_id_no').val() || [];
        const checkboxValue = $(this).val();

        if (this.checked) {
            // Add the value if checked
            if (!selectedValues.includes(checkboxValue)) {
                selectedValues.push(checkboxValue);
            }
        } else {
            // Remove the value if unchecked
            const index = selectedValues.indexOf(checkboxValue);
            if (index > -1) {
                selectedValues.splice(index, 1);
            }
        }

        // Update the Select2 field with the new selection
        $('#student_id_no').val(selectedValues).trigger('change');

        // Update the selected item count
        updateSelectedCount();
    });

    // Update count on initial load
    updateSelectedCount();

    // Update count whenever the value changes
    $('#student_id_no').on('change', function() {
        updateSelectedCount();
    });
});


    $('#pdf-btn').on('click', function (e) {
        e.preventDefault(); // Prevent default link behavior

        // Get filter data
        let route_id = $('#route_id').val();
        let stoppage_id = $('#stoppage_id').val();
        let student_id = $('#student-search-value').val(); 
        // let student_id = $('#student_id_no').val(); 
        // alert(student_id)
        if (!route_id && !stoppage_id && (!student_id || student_id.length === 0)) {
            Swal.fire({
                icon: 'warning',
                title: 'Field Not Selected',
                text: 'Please select at least one field.',
                confirmButtonText: 'OK'
            });
            return;
        }

        let selectedColumns = [];
        $('.toggle-column:checked').each(function () {
            selectedColumns.push($(this).val());
        });

        $.ajax({
            url: '{{ route("transport-route-wise-student-pdf-export") }}', // Route to handle PDF generation
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}', // Include CSRF token
                'route_id': route_id,
                'selected_columns': selectedColumns,
            },
            xhrFields: {
                responseType: 'blob', // Important for downloading files
            },
            success: function (data) {
                // Create a URL for the file blob
                const url = window.URL.createObjectURL(new Blob([data]));
                const a = document.createElement('a');
                a.href = url;
                a.download = 'transport-report.pdf'; // Set the file name
                document.body.appendChild(a);
                a.click();
                a.remove();
            },
            error: function (xhr) {
                console.error('Error exporting PDF:', xhr.responseText);
            }
        });
    });

    $('#excel-btn').on('click', function(e){
        e.preventDefault(); // Prevent default link behavior
        // Get filter data
        let route_id = $('#route_id').val();
        let stoppage_id = $('#stoppage_id').val();
        let student_id = $('#student-search-value').val(); 
        // let student_id = $('#student_id_no').val(); 
        // alert(student_id)
        if (!route_id && !stoppage_id && (!student_id || student_id.length === 0)) {
            Swal.fire({
                icon: 'warning',
                title: 'Field Not Selected',
                text: 'Please select at least one field.',
                confirmButtonText: 'OK'
            });
            return;
        }

        let selectedColumns = [];
        $('.toggle-column:checked').each(function () {
            selectedColumns.push($(this).val());
        });

        $.ajax({
            url: '{{ route("transport-route-wise-student-excel-export") }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}', // Include CSRF token
                'route_id': route_id,
                'selected_columns': selectedColumns,
            },
            xhrFields: {
                responseType: 'blob', // Important for downloading files
            },
            success: function (data) {
                // Create a URL for the file blob
                const url = window.URL.createObjectURL(new Blob([data]));
                const a = document.createElement('a');
                a.href = url;
                a.download = 'transport-report.xlsx'; // Set the file name
                document.body.appendChild(a);
                a.click();
                a.remove();
            },
            error: function (xhr) {
                console.error('Error exporting Excel:', xhr.responseText);
            }
        });
    });

    function restoreDefaultColumns() {
        // Set the default checked states
        $('#student_name').prop('checked', true);
        $('#student_id').prop('checked', true);
        $('#student_class').prop('checked', true);
        $('#guardian_name').prop('checked', true);
        $('#guardian_contact').prop('checked', true);
        $('#stoppage_id').prop('checked', true);
        $('#monthly_cost').prop('checked', true);
        // Reinitialize the table with the default column selection
        viewTable();
    }

    // Event listener for the "Restore Visibility" button
    $('.restorebutton').on('click', function() {
        restoreDefaultColumns();
    });

    let table; // Store DataTable instance
    function viewTable() {
        // Get filter data
        let route_id = $('#route_id').val();
        let stoppage_id = $('#stoppage_id').val();
        let student_id = $('#student-search-value').val(); 
        // let student_id = $('#student_id_no').val(); 
        // alert(student_id)
        if (!route_id && !stoppage_id && (!student_id || student_id.length === 0)) {
            Swal.fire({
                icon: 'warning',
                title: 'Field Not Selected',
                text: 'Please select at least one field.',
                confirmButtonText: 'OK'
            });
            return;
        }

        let selectedColumns = [];
        $('.toggle-column:checked').each(function () {
            selectedColumns.push($(this).val());
        });

        let columns = [];
        let columnHeaders = [];
        columns.push({ data: 'student_name', name: 'student_name', searchable: true });
        columnHeaders.push('Student Name');
     
        if(selectedColumns.includes('student_id')) {
            columns.push({ data: 'student_id', name: 'student_id' });
            columnHeaders.push('Student ID');
        }
        if(selectedColumns.includes('student_class')) {
            columns.push({ data: 'student_class', name: 'student_class' });
            columnHeaders.push('Class (Section)');
        }
        if(selectedColumns.includes('guardian_name')) {
            columns.push({ data: 'guardian_name', name: 'guardian_name' });
            columnHeaders.push('Guardian Name');
        }
        if(selectedColumns.includes('guardian_contact')) {
            columns.push({ data: 'guardian_contact', name: 'guardian_contact' });
            columnHeaders.push('Guardian Contact');
        }
        if(selectedColumns.includes('stoppage_id')) {
            columns.push({ data: 'stoppage_id', name: 'stoppage_id' });
            columnHeaders.push('Stoppage');
        }
        if(selectedColumns.includes('monthly_cost')) {
            columns.push({ data: 'monthly_cost', name: 'monthly_cost' });
            columnHeaders.push('Fee');
        }

        if ($.fn.DataTable.isDataTable('#transport')) {
            $('#transport').DataTable().clear().destroy();
        }

        const thead = $('#transport').find('thead');
        thead.empty();
        let headerRow = $('<tr></tr>');
        columnHeaders.forEach(header => {
            headerRow.append(`<th>${header}</th>`);
        });
        thead.append(headerRow);

        table = $('#transport').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('transport-route-wise-student-report-search') }}",
                type: "POST",
                data: function (d) {
                    d.selected_columns = selectedColumns;
                    d.route_id = route_id;
                    d.stoppage_id = stoppage_id;
                    d.student_id = student_id;
                },
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                dataSrc: function (response) {
                    $('#primary-info').html(`
                        <span><strong>Route Name: </strong> ${response.route_name}</span>
                        <span><strong>Vehicle: </strong> ${response.vehicle_number}</span>
                        <span><strong>Driver Name: </strong> ${response.driver_name}</span>
                        <span><strong>Driver Contact: </strong> ${response.driver_contact}</span>
                    `);
                    return response.data;
                }
            },
            columns: columns,
            language: {
                processing: "<span class='spinner-border spinner-border-sm' role='status' aria-hidden='true'></span> Loading..."
            },
            responsive: true,
            paging: true,
            info: true,
            lengthChange: true,
            searching: true,
            ordering: true
        });
    }

    $(document).on('change', '.toggle-column', function() {
        viewTable();
    });

    $(document).on('click', '#search', function () {
        viewTable();
    });

// print function
function printTable() {

    // Get filter data
    let route_id = $('#route_id').val();
    let stoppage_id = $('#stoppage_id').val();
    let student_id = $('#student-search-value').val(); 
    // let student_id = $('#student_id_no').val(); 
    // alert(student_id)
    if (!route_id && !stoppage_id && (!student_id || student_id.length === 0)) {
        Swal.fire({
            icon: 'warning',
            title: 'Field Not Selected',
            text: 'Please select at least one field.',
            confirmButtonText: 'OK'
        });
        return;
    }
    
    var selectedColumns = [];
    $('.toggle-column:checked').each(function () {
        selectedColumns.push($(this).val());
    });

    let columns = [];
    let columnHeaders = [];

    if (selectedColumns.includes('student_name')) {
        columns.push({ data: 'student_name', name: 'student_name' });
        columnHeaders.push('Student Name');
    }
    if (selectedColumns.includes('student_id')) {
        columns.push({ data: 'student_id', name: 'student_id' });
        columnHeaders.push('Student ID');
    }
    if (selectedColumns.includes('student_class')) {
        columns.push({ data: 'student_class', name: 'student_class' });
        columnHeaders.push('Class (Section)');
    }
    if (selectedColumns.includes('guardian_name')) {
        columns.push({ data: 'guardian_name', name: 'guardian_name' });
        columnHeaders.push('Guardian Name');
    }
    if (selectedColumns.includes('guardian_contact')) {
        columns.push({ data: 'guardian_contact', name: 'guardian_contact' });
        columnHeaders.push('Guardian Contact');
    }
    if (selectedColumns.includes('stoppage_id')) {
        columns.push({ data: 'stoppage_id', name: 'stoppage_id' });
        columnHeaders.push('Stoppage');
    }
    if (selectedColumns.includes('monthly_cost')) {
        columns.push({ data: 'monthly_cost', name: 'monthly_cost' });
        columnHeaders.push('Fee');
    }

    let tableContent = '<table border="1" style="width: 100%; border-collapse: collapse;">';

    tableContent += '<thead><tr>';
    columnHeaders.forEach(function (header) {
        tableContent += '<th style="border: 1px solid #ccc;padding: 5px;text-align: center;">' + header + '</th>';
    });
    tableContent += '</tr></thead><tbody>';

    let hasData = false;
    $('#transport tbody tr').each(function () {
        hasData = true;
        tableContent += '<tr>';
        $(this).find('td').each(function (index) {
            if (columns[index]) {
                tableContent += '<td style="border: 1px solid #ccc;padding: 5px;text-align: center;">' + $(this).text() + '</td>';
            }
        });
        tableContent += '</tr>';
    });

    if (!hasData) {
        tableContent += '<tr><td colspan="7" class="text-center">No data available in table</td></tr>';
    }

    tableContent += '</tbody></table>';

    const logoUrl = "{{ get_setting_value(Settings::EXPORT_LOGO) ? asset(get_setting_value(Settings::EXPORT_LOGO)) : asset('uploads/images/logo.png') ?? '' }}"; 
    const instituteName = "{{ get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '' }}";
    const branch_address = "{{ get_branch_info()->address ? get_branch_info()->address : '' }}";
    const branch_contact_info = "{{ get_branch_info()->contact_info ? get_branch_info()->contact_info : '' }}";
    const currDate = new Date();
    const currentDate =  `${(currDate.getMonth() + 1).toString().padStart(2, '0')}-${currDate.getDate().toString().padStart(2, '0')}-${currDate.getFullYear()}`;
    const primaryInfo = $("#primary-info").html();

    let printWindow = window.open('', '', 'height=800,width=1200');
    printWindow.document.write('<html><head><title>Print</title><style>');
    // Add CSS for alignment
    printWindow.document.write(`<style>
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding: 0 20px; /* Add padding to create space between edges and text */
        }
        .header-left {
            text-align: left;
            font-size: 14px;
            font-weight: bold; /* Make hostel name bold */
            flex: 1; /* Ensures it takes available space on the left */
        }
        .header-right {
            text-align: right;
            font-size: 14px;
            font-weight: bold; /* Make date bold */
        }
        table, th, td {
            border: 1px solid #ccc !important; /* Apply border color with high specificity */
            border-collapse: collapse;
        }
        th {
            font-family: sans-serif;
            text-align: center;
            padding: 10px 8px !important;
            background: #eaecf4;
            font-weight: 400 !important;
        }
        td {
            text-align: center;
            padding: 8px;
            color: #292929;
        }
        tr {
            border: 1px solid #ccc; /* Ensure row borders are styled */
        }
        td, th {
            border-color: #ccc; /* Explicitly set border color for td and th */
        }
    </style>`);
    printWindow.document.write('</style></head><body>');
    printWindow.document.write('<div style="text-align: center; margin-bottom: 20px;font-family: sans-serif;color:#1d1d1d ;">');
    printWindow.document.write('<img src="' + logoUrl + '" alt="Institute Logo" style="height: 80px;padding-bottom:10px !important;">');
    printWindow.document.write('<h2 style="margin: 0;">' + instituteName + '</h2>');
    printWindow.document.write('<p style="margin: 0;">' + branch_address + '</p>');
    printWindow.document.write('<p style="margin: 0;">' + branch_contact_info + '</h2>');
    printWindow.document.write('<p style="margin: 0;"><strong>Transport Report</strong></p>');
    printWindow.document.write('</div>');

    //table top info
    printWindow.document.write('<div class="table-top">');
    printWindow.document.write('<table style="border: none !important; width: 100%; margin: 0px 0px 10px 0px; padding: 0px;">');
    printWindow.document.write('<tbody><tr style="width: 100%;border: none !important;">');
    printWindow.document.write('<td style="text-align: left; width: 80%;border: none !important;padding: 0px;">' + primaryInfo + '</td>'); 
    printWindow.document.write('<td style="text-align: right; width: 20%;border: none !important;padding: 0px;"> <strong>Date: </strong>' + currentDate + '</td>'); 
    printWindow.document.write('</tr></tbody></table>');
    printWindow.document.write('</div>');

    printWindow.document.write(tableContent);
    printWindow.document.write('</body></html>');
    printWindow.document.close();

    // Attach the onafterprint event
    printWindow.onafterprint = function () {
        printWindow.close();
    };

    // Add a delay to ensure resources are loaded before printing
    setTimeout(() => {
        printWindow.print();
    }, 500);
}
</script>
@endsection
