<table>
    @php
        $branch_info = get_branch_info();
    @endphp
    <thead>
        <tr>
            <th colspan="{{ count($columns) + (in_array('SL', $columns) ? 1 : 0) }}" style="text-align: center;">
                {{ $report_name ?? 'N/A' }} (Address: {{ $branch_info->address ?? '' }})  (Contact No: {{ $branch_info->contact_info ?? '' }}) (Route Name: {{ $route_name ?? 'N/A' }}) (Vehicle: {{ $vehicle_number ?? 'N/A' }}) (Driver Name: {{ $driver_name ?? 'N/A' }}) ( Driver Contact : {{ $driver_contact ?? 'N/A' }})  
            </th> 
        </tr>
        <tr>
            @foreach($columns as $column)
                @if($column == 'student_name')
                <th class="left">Student Name</th>
                @elseif($column == 'student_id')
                <th>Student ID</th>
                @elseif($column == 'student_class')
                <th>Class (Section)</th>
                @elseif($column == 'guardian_name')
                <th>Guardian Name</th>
                @elseif($column == 'guardian_contact')
                <th>Guardian Contact</th>
                @elseif($column == 'stoppage_id')
                <th>Stoppage</th>
                @elseif($column == 'monthly_cost')
                <th>Fee</th>
                @endif
            @endforeach
        </tr>
    </thead>
    <tbody>
        @foreach($transports as $item)
            <tr>
                @foreach($columns as $column)
                    @if($column == 'student_name')
                        <td class="left">{{ $item->studentInfo->name ?? 'N/A' }}</td>
                    @elseif($column == 'student_id')
                        <td>{{ $item->studentInfo->student_id_no ?? 'N/A' }}</td>
                    @elseif($column == 'student_class')
                        <td>{{$item->studentInfo->studentClass->class_name ?? 'N/A'}}  ({{$item->studentInfo->section->section_name ?? 'N/A'}})</td>
                    @elseif($column == 'guardian_name')
                        <td>{{ $item->studentInfo->guardian_name ?? 'N/A' }}</td>  
                    @elseif($column == 'guardian_contact')
                        <td>{{ $item->studentInfo->guardian_mobile ?? 'N/A' }}</td>    
                    @elseif($column == 'stoppage_id')
                        <td>{{ $item->stoppage->name ?? 'N/A' }}</td>         
                    @elseif($column == 'monthly_cost')
                        <td>{{ $item->monthly_cost ?? 'N/A' }}</td>
                    @endif
                @endforeach
            </tr>
        @endforeach

    </tbody>
</table>