<!doctype html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $report_name ?? 'Report' }}</title>
    <style>
    .center{
        text-align: center;
    }
    .left{
        text-align: left;
    }
    .right{
        text-align: right;
    }
    .header {
        padding: 10px;
/*        border-bottom: 1px solid #ccc;*/
        text-align: center;
    }
    .header img{
        width: auto;
        height: 50px;
        padding: .25rem !important;
        filter: invert(1);
        opacity: .7;
    }
    .header .institute-name{
        padding: 0;
        margin: 0;
    } 
    .header p{
        margin: 0;
        padding: 0;
    }
    .main-table{
        width: 100%;
    }
    .main-table thead{
        background-color:#eaecf4;
        color: black;
        width: 100%;
    }
    .download-date{
        text-align: left;
        font-size: 15px;
        padding-top: 10px;
    }
    .main-table thead tr th{
        text-transform: capitalize;
    }
    table.main-table {
       border-collapse: collapse;
    }
    table.main-table td,  table.main-table th {
        border: 1px solid #e3e6f0;
        font-size: 14px;
        text-align: center;
    }
    table.main-table thead tr th{
        margin-bottom: 5px;
        font-size: 14px;
    }
    table.main-table tbody tr td:last-child{
        text-transform: capitalize;
    }

</style>
</head>
<body>
    <div class="card">
        <div class="header">
                @php
                    $logo_path = get_setting_value(Settings::EXPORT_LOGO) ? get_setting_value(Settings::EXPORT_LOGO) : 'uploads/images/logo.png';
                    $institute_name = get_setting_value(Settings::SCHOOL_NAME) ? get_setting_value(Settings::SCHOOL_NAME) : '';
                    $branch_info = get_branch_info();
                @endphp
                <img src="{{public_path($logo_path)}}">
            <h2 class="institute-name">{{ $institute_name ?? '' }}</h2> 
            <p class="institute-name">{{ $branch_info->address ?? '' }}</p> 
            <p class="institute-name">{{ $branch_info->contact_info ?? '' }}</p>
            <p><strong>{{ $report_name ?? 'Report' }}</strong></p>
            
        </div>

        <table style="width: 100%; border: none;">
            <tbody>
                <tr>
                    <td style="text-align: left; border: none; width: 80%;"><strong>Route Name:</strong> {{ $route_name ?? 'N/A' }} <strong>Vehicle:</strong> {{ $vehicle_number ?? 'N/A' }} <br> <strong>Driver Name:</strong> {{ $driver_name ?? 'N/A' }} <strong>Driver Contact:</strong> {{ $driver_contact ?? 'N/A' }} </td>
                    <td style="text-align: right; border: none; width: 20%;"><strong>Date:</strong> {{ date('d-m-Y') }}</td>
                </tr>
            </tbody>
        </table>
        <table class="main-table">
            <thead>
                <tr>
                    @foreach($columns as $column)
                        @if($column == 'student_name')
                        <th class="left">Student Name</th>
                        @elseif($column == 'student_id')
                        <th>Student ID</th>
                        @elseif($column == 'student_class')
                        <th>Class (Section)</th>
                        @elseif($column == 'guardian_name')
                        <th>Guardian Name</th>
                        @elseif($column == 'guardian_contact')
                        <th>Guardian Contact</th>
                        @elseif($column == 'stoppage_id')
                        <th>Stoppage</th>
                        @elseif($column == 'monthly_cost')
                        <th>Fee</th>
                        @endif
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @foreach($transports as $item)
                    <tr>
                        @foreach($columns as $column)
                            @if($column == 'student_name')
                                <td class="left">{{ $item->studentInfo->name ?? 'N/A' }}</td>
                            @elseif($column == 'student_id')
                                <td>{{ $item->studentInfo->student_id_no ?? 'N/A' }}</td>
                            @elseif($column == 'student_class')
                                <td>{{$item->studentInfo->studentClass->class_name ?? 'N/A'}}  ({{$item->studentInfo->section->section_name ?? 'N/A'}})</td>
                            @elseif($column == 'guardian_name')
                                <td>{{ $item->studentInfo->guardian_name ?? 'N/A' }}</td>  
                            @elseif($column == 'guardian_contact')
                                <td>{{ $item->studentInfo->guardian_mobile ?? 'N/A' }}</td>    
                            @elseif($column == 'stoppage_id')
                                <td>{{ $item->stoppage->name ?? 'N/A' }}</td>         
                            @elseif($column == 'monthly_cost')
                                <td>{{ $item->monthly_cost ?? 'N/A' }}</td>
                            @endif
                        @endforeach
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>   
</body>
</html>