@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Role: {{$role->name}} </h5>
        <a href="{{ route('roles.index') }}" class="btn btn-sm btn-primary">Role List</a>
    </div>
    <div class="card-body">
        @if ($hierarchicalPermissions->count()>0)
            <form action="{{ route('roles.assign-permission',$role->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="mb-3">

                    <div class="row">
                        @foreach ($hierarchicalPermissions as $categoryName => $categories)
                            <div class="col-md-4 mb-4">
                                <div class="border rounded-sm">

                                    <label class="alert alert-light w-100">
                                        @if(isset($categories['standalone'][0]))
                                            <span class="h4">{{ ucfirst(ucwords(str_replace('-', ' ', $categories['standalone'][0]['display_name']))) }}</span>
                                        @else
                                            <span class="h4">No Display Name</span> <!-- Or any default message -->
                                        @endif
                                        ( <input type="checkbox" class="category-checkbox" data-category="{{ $categoryName }}"> Select All )
                                    </label>

                                    @foreach ($categories['standalone'] as $permission)
                                        <div class="col-md-12 mb-2">
                                            <label class="p-1 rounded-sm">
                                                <input type="checkbox" name="permission[]" value="{{ $permission->name }}" class="permission-checkbox {{ $categoryName }}-checkbox" {{ in_array($permission->id, $assignPermissions) ? 'checked' : '' }}>
                                                {{ $permission->display_name }}
                                            </label>
                                        </div>
                                    @endforeach
                                    @foreach ($categories['grouped'] as $subCategoryName => $permissions)
                                        <div class="col-md-12">

                                            <label class="alert-light px-1">
                                                <span class="h5">{{ ucfirst(str_replace('-', ' ', $subCategoryName)) }}</span>
                                                ( <input type="checkbox" class="subcategory-checkbox" data-subcategory="{{ $subCategoryName }}" data-category="{{ $categoryName }}"> Select All )
                                            </label>

                                            @foreach ($permissions as $permission)
                                                <div class="col-md-12 mb-2">
                                                    <label class="p-1 rounded-sm">
                                                        <input type="checkbox" name="permission[]" value="{{ $permission->name }}" class="permission-checkbox {{ $categoryName }}-checkbox {{ $subCategoryName }}-checkbox" {{ in_array($permission->id, $assignPermissions) ? 'checked' : '' }}>
                                                        {{ $permission->display_name }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endforeach

                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <div class="mb-3">
                    <button class="btn btn-primary">Update</button>
                </div>

            </form>
        @endif

    </div>
</div>
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            // Handle category checkbox change
            $('.category-checkbox').change(function() {
                var category = $(this).data('category');
                $('.' + category + '-checkbox').prop('checked', $(this).prop('checked'));
            });

            // Handle subcategory checkbox change
            $('.subcategory-checkbox').change(function() {
                var subcategory = $(this).data('subcategory');
                $('.' + subcategory + '-checkbox').prop('checked', $(this).prop('checked'));
            });

            // Handle individual permission checkbox change
            $('.permission-checkbox').change(function() {
                var category = $(this).closest('.col-md-4').find('.category-checkbox').data('category');
                var subcategory = $(this).closest('.col-md-12').find('.subcategory-checkbox').data('subcategory');

                // Update category checkbox based on permissions
                if ($('.' + category + '-checkbox:checked').length === $('.' + category + '-checkbox').length) {
                    $('.category-checkbox[data-category="' + category + '"]').prop('checked', true);
                } else {
                    $('.category-checkbox[data-category="' + category + '"]').prop('checked', false);
                }

                // Update subcategory checkbox based on permissions
                if (subcategory) {
                    if ($('.' + subcategory + '-checkbox:checked').length === $('.' + subcategory + '-checkbox').length) {
                        $('.subcategory-checkbox[data-subcategory="' + subcategory + '"]').prop('checked', true);
                    } else {
                        $('.subcategory-checkbox[data-subcategory="' + subcategory + '"]').prop('checked', false);
                    }
                }
            });
        });
    </script>
@endsection
