@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Create Permissions</h5>
        <a href="{{ route('permissions.index') }}" class="btn btn-sm btn-primary">Permissions</a>
    </div>
    <div class="card-body">
        <form action="{{ url('permissions') }}" method="POST">
            @csrf
            <div class="d-flex flex-column align-items-center">
                <div class="mb-3 col-md-5">
                    <label for="permission_name">Module Name</label>
                    {{ generateDropdown($permissionCategory, 'class="form-control select2 name" id="name" name="name" required', '', "Select Module") }}
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permission_name">Sub Module Name</label>
                    {{ generateDropdown([], 'class="form-control select2 subname" id="subname" name="subname"', '', "Select Sub Module") }}
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permission_name">Permission Action</label>
                    @php
                        $actions = [
                            'view' => 'View',
                            'create' => 'Create',
                            'edit' => 'Edit',
                            'delete' => 'Delete'
                        ];
                    @endphp
                    {{ generateDropdown($actions, 'class="form-control action_name" id="action_name" name="action_name"', '', "Select Action Name") }}

                </div>
                <div class="mb-3 col-md-5">
                    <label for="display_name" onclick="copyText()">Display Name</label>
                    <span title="Copy Permission" class="copy-icon" onclick="copyText()">
                        <i class="fas fa-copy" style="cursor: pointer;"></i>
                    </span>
                    <input type="text" name="display_name" id="display_name" class="form-control" placeholder="Enter display permission name">
                </div>

                <div class="mb-3 col-md-5 d-flex flex-row align-items-end">
                    <button class="btn btn-primary mr-1" name="submit" value="all">Create for all action</button>
                    <button class="btn btn-primary" name="submit" value="single">Create for selected action</button>
                </div>
            </div>
        </form>
    </div>
</div>

@section('scripts')
<script>
$(document).ready(function () {

    $('#name').change(function () {
        var categorySlug = $(this).val();
        $.ajax({
            url: '{{ url('permissions/get-sub-cat') }}/' + categorySlug,
            type: 'GET',
            success: function (data) {
                $('#subname').empty();
                $('#subname').append('<option value="">--Select Sub Module--</option>');
                $.each(data, function (key, value) {
                    $('#subname').append('<option value="' + key + '">' + value + '</option>');
                });
            }
        });
    });
});

function copyText(){
    let action_name = $('#action_name option:selected').text();
    let subname = $('#subname option:selected').text();
    let display_name = action_name+' '+subname;
    $('#display_name').val(display_name);
}
</script>
@endsection
@stop
