@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header card-custom-bg d-flex flex-row align-items-center justify-content-between">
        <h5>Edit Permissions</h5>
        <a href="{{ route('permissions.index') }}" class="btn btn-sm btn-primary">Permissions</a>
    </div>
    <div class="card-body">
        <form action="{{ route('permissions.update', $permission->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="d-flex flex-column align-items-center">
                <div class="mb-3 col-md-5">
                    <label for="permission_name">Permission Module</label>
                    {{ generateDropdown($permissionCategories, 'class="form-control name" id="name" name="name" required', $selectedCategory ? $selectedCategory : '', "--Select Module--") }}
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permission_name">Permission Sub Module</label>
                    {{ generateDropdown([], 'class="form-control subname" id="subname" name="subname"', $selectedSubCategory ? $selectedSubCategory : '', "--Select Sub Module--") }}
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permission_name">Permission Action</label>
                    @php
                        $actions = [
                            'view' => 'View',
                            'create' => 'Create',
                            'edit' => 'Edit',
                            'delete' => 'Delete'
                        ];
                    @endphp
                    {{ generateDropdown($actions, 'class="form-control action_name" id="action_name" name="action_name"', $selectedAction, "Select Action Name") }}
                </div>
                <div class="mb-3 col-md-5">
                    <label for="display_name">Display Name</label>
                    <input type="text" name="display_name" value="{{ $permission->display_name }}" class="form-control" placeholder="Enter display permission name">
                </div>
                <div class="mb-3 col-md-5 d-flex flex-column align-items-end">
                    <button class="btn btn-primary">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>

@section('scripts')
<script>
$(document).ready(function () {
    var selectedCategory = '{{ $selectedCategory ? $selectedCategory : '' }}';
    var selectedSubCategory = '{{ $selectedSubCategory ? $selectedSubCategory : '' }}';

    if (selectedCategory) {
        fetchSubCategories(selectedCategory, selectedSubCategory);
    }

    $('#name').change(function () {
        var categorySlug = $(this).val();
        fetchSubCategories(categorySlug, '');
    });

    function fetchSubCategories(categorySlug, selectedSubCategory) {
        $.ajax({
            url: '{{ url('permissions/get-sub-cat') }}/' + categorySlug,
            type: 'GET',
            success: function (data) {
                $('#subname').empty();
                $('#subname').append('<option value="">--Select Sub Module--</option>');
                $.each(data, function (key, value) {
                    var isSelected = key === selectedSubCategory ? 'selected' : '';
                    $('#subname').append('<option value="' + key + '" ' + isSelected + '>' + value + '</option>');
                });
            }
        });
    }
});
</script>
@endsection
@stop
