@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">Permissions</h6>
        <div class="m-0 float-right">
            <a href="{{ route('permissions.create') }}" class="btn btn-sm btn-light-blue">Add New</a>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table" id="dataTable">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Permission Name</th>
                            <th>Display Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $sn = 0;
                        @endphp
                        @foreach ($permissions as $permission)
                            <tr>
                                <td>{{++$sn}}</td>
                                <td style="position: relative;">
                                    <span title="Copy Permission" class="copy-icon" onclick="copyText(this)">
                                        <i class="fas fa-copy" style="cursor: pointer;"></i>
                                    </span>
                                    <span class="copy-text" >{{$permission->name}}</span>
                                </td>
                                <td>{{$permission->display_name}}</td>
                                <td class="d-flex justify-content-start">
                                    <a class="btn btn-sm btn-soft-info mr-1" href="{{route('permissions.edit', $permission->id)}}"><i class="fas fa-edit"></i></a>
                                    <a class="btn btn-sm btn-soft-danger" href="{{route('permissions.destroy', $permission->id)}}" onclick="return confirm('Are you sure you want to delete this')"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    function copyText(element) {
        var textElement = element.nextElementSibling; // Get the sibling span containing text
        var text = textElement.innerText.trim(); // Get the trimmed text

        // Create a temporary textarea to copy the text
        var textarea = document.createElement('textarea');
        textarea.value = text;
        document.body.appendChild(textarea);

        // Select and copy the text
        textarea.select();
        document.execCommand('copy');

        // Clean up - remove the textarea
        document.body.removeChild(textarea);

        // Show the checked icon briefly for visual feedback
        var copyIcon = element.querySelector('i'); // Get the copy icon
        copyIcon.classList.remove('fa-copy'); // Remove copy icon class
        copyIcon.classList.add('fa-check-circle'); // Add checked icon class
        copyIcon.style.color = 'green'; // Set checked icon color

        // Reset to copy icon after 1.5 seconds
        setTimeout(function() {
            copyIcon.classList.remove('fa-check-circle'); // Remove checked icon class
            copyIcon.classList.add('fa-copy'); // Add copy icon class back
            copyIcon.style.color = ''; // Reset icon color
        }, 1500);
    }
</script>
@stop

