@extends('layouts.master')
@section('content')
<div class="card">
    <div class="card-header d-flex flex-row align-items-center justify-content-between mb-4">
        <h5 class="text-gray-900">Assign Role</h5>
        <a href="{{ route('permissions.users.list') }}" class="btn btn-sm btn-light-blue">View All</a>
    </div>
    <div class="card-body">
        <form action="{{ route('roles.assign-role-store') }}" method="POST">
            @csrf
            <div class="d-flex flex-column align-items-center">
                <div class="mb-3 col-md-5">
                    <label for="permanent_address">User Name</label>
                    <input type="text" value="{{$user->name}}" class="form-control" disabled>
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permanent_address">User Phone</label>
                    <input type="text" value="{{$user->phone_number}}" class="form-control" disabled>
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permanent_address">User Email</label>
                    <input type="text" value="{{$user->email}}" class="form-control" disabled>
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permanent_address">User Type</label>
                    <input type="text" value="{{$user->user_type}}" class="form-control" disabled>
                </div>
                <div class="mb-3 col-md-5">
                    <label for="permanent_address">Select Role (You can select multiple)</label>
                    <select name="roles[]" class="form-control select2" multiple>
                        @php
                            $userRoles = $user->getRoleNames()->toArray();
                        @endphp
                        @foreach ($roles as $role)
                            <option value="{{$role->name}}" {{in_array($role->name, $userRoles) ? 'selected' : ''}}>{{ucfirst(ucwords(str_replace('-', ' ', $role->name)))}}</option>
                        @endforeach
                    </select>
                </div>
<br>
                <div class="col-md-5 d-flex justify-content-end">
                    <a href="{{ route('permissions.users.list') }}" type="button" class="btn btn-default mr-2">Discard</a>
                    <button class="btn btn-submit">Submit</button>
                </div>
            </div>
        </form>
    </div>
</div>
@stop
