@extends('layouts.master')
@section('content')
<div class="card mt-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 table__top__txt">User List</h6>
        <div class="m-0 float-right">

        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive" >
                <table class="table">
                    <thead class="thead-light">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Branch</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $sn = 0;
                        @endphp
                        @foreach ($user_list as $user)
                            <tr>
                                <td>{{++$sn}}</td>
                                <td>{{$user->name}}</td>
                                <td>{{$user->phone_number}}</td>
                                <td>{{$user->branch->branch_name}}</td>
                                <td class="td__email" style="text-transform: lowercase;">{{$user->email}}</td>
                                <td>
                                    @php
                                        $userRoleArray = $user->getRoleNames();
                                    @endphp
                                    @if (!empty($userRoleArray))
                                        @foreach ($userRoleArray as $roleName)
                                            <span class="badge badge-primary mx-1">{{ucfirst(ucwords(str_replace('-', ' ', $roleName)))}}</span>
                                        @endforeach
                                    @endif
                                </td>
                                <td>
                                    <a class="btn btn-sm btn-success" href="{{route('roles.assign-role', $user->id)}}">Assign Role</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>
@stop
