@extends('layouts.master')
@section('content')
    <div class="card std__form">
        <div class="card-header mt-2">
            <h5>System Settings</h5>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger m-3">
                <ul class="m-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form action="{{ route('setting.update') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="py-2 px-3 mb-3 text-white form__head">
                    Accounting Setting
                </div>
                <div class="p-2 form__body">
                    <div class="col-md-12">
                        <div class="row">
                            @php 
                                $branch_id = auth()->user()->branch_id;
                                $late_fine_start_day = get_setting(Settings::LATE_FINE_START_DAY.'_'.$branch_id)
                            @endphp
                            @if (!empty($late_fine_start_day))
                                <div class="form-group col-md-4">
                                    <label for="{{ $late_fine_start_day->key }}">Late fine start day</label>
                                    <input type="number" class="form-control" min="0"
                                        name="{{ $late_fine_start_day->key }}" value="{{ $late_fine_start_day->value }}"
                                        placeholder="Late fine start day">
                                </div>
                            @endif

                            @php
                                $late_fine_amount = get_setting(Settings::LATE_FINE_AMOUNT.'_'.$branch_id)
                            @endphp
                            @if (!empty($late_fine_amount))
                                <div class="form-group col-md-4">
                                    <label for="{{ $late_fine_amount->key }}">Late fine amount (TK.)</label>
                                    <input type="number" class="form-control" min="0"
                                        name="{{ $late_fine_amount->key }}" value="{{ $late_fine_amount->value }}"
                                        placeholder="Late fine amount">
                                </div>
                            @endif

                            @php 
                                $salary_expense_head = get_setting(Settings::SALARY_EXPENSE_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $salary_expense_head->key }}">Salary Expense Head</label>
                                {{ generateDropdown($expense_heads, 'class="form-control" name="'.$salary_expense_head->key.'"', $salary_expense_head->value, "Select Expense") }}
                            </div>

                            @php 
                                $nurani_fees_income_head = get_setting(Settings::NURANI_FEES_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $nurani_fees_income_head->key }}">Nurani Fees Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$nurani_fees_income_head->key.'"', $nurani_fees_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $nurani_admission_income_head = get_setting(Settings::NURANI_ADMISSION_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $nurani_admission_income_head->key }}">Nurani Admission Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$nurani_admission_income_head->key.'"', $nurani_admission_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $hifz_boys_fees_income_head = get_setting(Settings::HIFZ_BOYS_FEES_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $hifz_boys_fees_income_head->key }}">Hifz Boys Fees Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$hifz_boys_fees_income_head->key.'"', $hifz_boys_fees_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $hifz_girls_fees_income_head = get_setting(Settings::HIFZ_GIRLS_FEES_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $hifz_girls_fees_income_head->key }}">Hifz Girls Fees Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$hifz_girls_fees_income_head->key.'"', $hifz_girls_fees_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $hifz_boys_admission_income_head = get_setting(Settings::HIFZ_BOYS_ADMISSION_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $hifz_boys_admission_income_head->key }}">Hifz Boys Admission Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$hifz_boys_admission_income_head->key.'"', $hifz_boys_admission_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $hifz_girls_admission_income_head = get_setting(Settings::HIFZ_GIRLS_ADMISSION_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $hifz_girls_admission_income_head->key }}">Hifz Girls Admission Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$hifz_girls_admission_income_head->key.'"', $hifz_girls_admission_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $kawmi_fees_income_head = get_setting(Settings::KAWMI_FEES_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $kawmi_fees_income_head->key }}">Kawmi Fees Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$kawmi_fees_income_head->key.'"', $kawmi_fees_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $kawmi_admission_income_head = get_setting(Settings::KAWMI_ADMISSION_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $kawmi_admission_income_head->key }}">Kawmi Admission Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$kawmi_admission_income_head->key.'"', $kawmi_admission_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $aliya_fees_income_head = get_setting(Settings::ALIYA_FEES_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $aliya_fees_income_head->key }}">Aliya Fees Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$aliya_fees_income_head->key.'"', $aliya_fees_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $aliya_admission_income_head = get_setting(Settings::ALIYA_ADMISSION_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $aliya_admission_income_head->key }}">Aliya Admission Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$aliya_admission_income_head->key.'"', $aliya_admission_income_head->value, "Select Income") }}
                            </div>

                            @php 
                                $other_fees_income_head = get_setting(Settings::OTHER_FEES_INCOME_HEAD.'_'.$branch_id)
                            @endphp
                            <div class="form-group col-md-4">
                                <label for="{{ $other_fees_income_head->key }}">Other Fees Income Head</label>
                                {{ generateDropdown($income_heads, 'class="form-control" name="'.$other_fees_income_head->key.'"', $other_fees_income_head->value, "Select Income") }}
                            </div>
                        
                        </div>
                    </div>

                </div>

                <div class="mt-3 flex justify-content-end">
                    <button type="submit" id="submitBtn" class="btn btn-primary float-right">Submit</button>
                </div>
            </form>
        </div>
    </div>
@endsection


@section('scripts')
    <script>
        $(document).ready(function() {
            $('.profile-img-input2').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow2').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
            $('.profile-img-input3').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow3').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })

            $('.profile-img-input4').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow4').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
            $('.profile-img-input5').change(function(e) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('.profileImgShow5').attr('src', e.target.result);
                }
                reader.readAsDataURL(e.target.files['0']);
            })
        });
    </script>
@stop
