@extends('students-dashboard.app')

@section('content')

    <style>
        .student__login .pass__field {
            position: relative;
        }

        .student__login .pass__field .view__pass {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            z-index: 2; /* Ensure the icon is above the input field */
        }

        .student__login .pass__field .view__pass i {
            color: #9f9f9f;
        }
    </style>

    <div class="row justify-content-center">
        <div class="col-xl-5 col-lg-6 col-md-9">
            <div class="card shadow-sm my-5">
                <div class="card-body p-5">
                    <div class="row">
                        <div class="col-lg-12">
                            @if (session('status'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('status') }}
                                </div>
                            @endif
                            <div class="student__login">

                                <form method="POST" action="{{ route('student.password-change') }}">
                                    @csrf
                                    <div class="form-group">
                                        <label for="password">New Password:</label>
                                        <div class="pass__field">
                                            <input type="password" id="password" class="form-control" name="password" autocomplete="off" required>
                                            <div class="view__pass">
                                                <span onclick="togglePasswordVisibility('password')">
                                                    <i class="fas fa-eye" id="password-eye"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="password_confirmation">Confirm New Password:</label>
                                        <div class="pass__field">
                                            <input type="password" id="password_confirmation" class="form-control" name="password_confirmation" autocomplete="off" required>
                                            <div class="view__pass">
                                                <span onclick="togglePasswordVisibility('password_confirmation')">
                                                    <i class="fas fa-eye" id="password_confirmation-eye"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary w-100">Change Password</button>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Font Awesome for the eye icon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <script>
        function togglePasswordVisibility(fieldId) {
            const passwordField = document.getElementById(fieldId);
            const eyeIcon = document.getElementById(`${fieldId}-eye`);

            if (passwordField.type === "password") {
                passwordField.type = "text";
                eyeIcon.classList.remove("fa-eye");
                eyeIcon.classList.add("fa-eye-slash");
            } else {
                passwordField.type = "password";
                eyeIcon.classList.remove("fa-eye-slash");
                eyeIcon.classList.add("fa-eye");
            }
        }
    </script>

@endsection