@extends('students-dashboard.app')
@push('styles')
<style>
    .fc .fc-button:disabled{
        display: none;
    }
    .fc .fc-toolbar-title{
        font-size: 20px;
    }
    .fc-event, .fc-event-dot{
        background: #283f7d;
    }
</style>
@endpush
@section('content')


    <section class="std__summary mb-4">
        <div class="row">
            <div class="col-md-10 m-auto">
                <div class="row">
                    <div class="col-md-6 col-xl-4 std__summary__profile">
                        <div class="card text-center d-none d-md-block d-lg-block">
                            <div class="card-block profile-intro">
                                <div class="content text-center">
                                    @php
                                        $student_image = $studentInfo->profile_image ? $studentInfo->profile_image : 'uploads/student/graduated_student.png';
                                    @endphp
                                    <div class="avatar">
                                        <img src="{{asset($student_image)}}" alt="{{$studentInfo->name}} ss">
                                    </div>
                                    <h4 class="profile-user">{{$studentInfo->name}}</h4>
                                    <p class="profile-job">

                                    </p>
                                    <table class="table mt-20">
                                        <tbody>
                                            <tr>
                                                <th>ID</th>
                                                <td>{{$studentInfo->student_id_no}}</td>
                                            </tr>
                                            <tr>
                                                <th>Session</th>
                                                <td>{{getDefaultAcademicYearValue()}}</td>
                                            </tr>
                                            <tr>
                                                <th>Class</th>
                                                <td>{{$studentInfo->studentClass->class_name}}</td>
                                            </tr>
                                            <tr>
                                                <th>Section</th>
                                                <td>{{$studentInfo->section->section_name ?? 'N/A'}}</td>
                                            </tr>
                                            <tr>
                                                <th>Roll</th>
                                                <td>{{$studentInfo->class_roll}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div style="height: 20px"></div>
                                <svg class="svg-intro-bottom" 
                                    xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 100 100" 
                                    preserveAspectRatio="none">
                                    <path d="M0,70 C30,130 70,50 100,70 L100,100 0,100 Z" fill="#f6f7fb">
                                    </path>
                                </svg>
                                <svg class="svg-intro-bottom-2" 
                                    xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 100 100" 
                                    preserveAspectRatio="none">
                                    <path d="M0,70 C30,130 70,50 100,70 L100,100 0,100 Z" fill="#ffffff"
                                        fill-opacity="0.4"></path>
                                </svg>
                                <svg class="svg-intro-bottom-3" 
                                    xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 100 100" 
                                    preserveAspectRatio="none">
                                    <path d="M95,0 Q90,90 10,100 L100,100 100,0 Z" fill="#ffffff"
                                        fill-opacity="0.1"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="content card-block d-block d-md-none d-lg-none text-center">
                            <div class="avatar">
                                <img src="{{asset($student_image)}}" alt="{{$studentInfo->name}}">
                            </div>
                            <div class="std__info text-center">
                                <div class="name">
                                    <h4>{{$studentInfo->name}}</h4>
                                </div>
                                <div class="d-flex justify-content-center">
                                    <p>Student ID: {{$studentInfo->student_id_no}}</p>
                                    <p>Class: {{$studentInfo->studentClass->class_name}} {{$studentInfo?->section?->section_name ? '('.$studentInfo?->section?->section_name.')' : ''}}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-8 std__summary">
                        <div class="row">
                            <div class="col-md-6 col-xl-6 col-6">
                                <a href="{{route('student.my-fees')}}">
                                    <div class="card bg-grd-primary order-card">
                                        <div class="card-body d-flex justify-content-between align-items-center">
                                            <div class="title">
                                                <h1 class="text-white">{{round($feeDetails->grand_total_amount)}}</h1>
                                                <h5 class="text-white">Total Fees</h5>
                                            </div>
                                            <div class="icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" width="64" height="64"
                                                    stroke-width="0.75">
                                                    <path d="M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                                                    <path
                                                        d="M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z">
                                                    </path>
                                                    <path d="M18 12l.01 0"></path>
                                                    <path d="M6 12l.01 0"></path>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-xl-6 col-6">
                                <a href="{{route('student.due-fees')}}">
                                    <div class="card bg-grd-success order-card">
                                        <div class="card-body d-flex justify-content-between align-items-center">
                                            <div class="title">
                                                <h1 class="text-white">{{round($feeDetails->grand_due_amount)}}</h1>
                                                <h5 class="text-white">Due Fees</h5>
                                            </div>
                                            <div class="icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" width="64" height="64"
                                                    stroke-width="0.75">
                                                    <path d="M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                                                    <path
                                                        d="M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z">
                                                    </path>
                                                    <path d="M18 12l.01 0"></path>
                                                    <path d="M6 12l.01 0"></path>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-xl-6 col-6">
                                <a href="{{route('student.my-subjects')}}">
                                    <div class="card bg-grd-warning order-card">
                                        <div class="card-body d-flex justify-content-between align-items-center">
                                            <div class="title">
                                                <h1 class="text-white">{{$studentInfo->studentClass->subjectAssignments->count()}}</h1>
                                                <h5 class="text-white">My Subjects</h5>
                                            </div>
                                            <div class="icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" width="62" height="62"
                                                    stroke-width="0.75">
                                                    <path d="M4 4h6v6h-6z"></path>
                                                    <path d="M14 4h6v6h-6z"></path>
                                                    <path d="M4 14h6v6h-6z"></path>
                                                    <path d="M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"></path>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-xl-6 col-6">
                                <a href="{{route('student.my-friends')}}">
                                    <div class="card bg-grd-custom order-card">
                                        <div class="card-body d-flex justify-content-between align-items-center">
                                            <div class="title">
                                                <h1 class="text-white">{{$myFriends->count()}}</h1>
                                                <h5 class="text-white">My Friends</h5>
                                            </div>
                                            <div class="icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" width="64" height="64"
                                                    stroke-width="0.75">
                                                    <path
                                                        d="M3 15m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z">
                                                    </path>
                                                    <path
                                                        d="M15 15m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z">
                                                    </path>
                                                    <path
                                                        d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z">
                                                    </path>
                                                    <path d="M6 15v-1a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v1"></path>
                                                    <path d="M12 9l0 3"></path>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-xl-6 col-6">
                                <a href="{{route('student.leave-history')}}">
                                    <div class="card bg-grd-deeporng order-card">
                                        <div class="card-body d-flex justify-content-between align-items-center">
                                            <div class="title">
                                                <h1 class="text-white">{{$myApprovedLeaves->count()}}</h1>
                                                <h5 class="text-white">Leave</h5>
                                            </div>
                                            <div class="icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" width="64" height="64"
                                                    stroke-width="0.75">
                                                    <path d="M12 4h-6a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h8"></path>
                                                    <path d="M18 20v-17"></path>
                                                    <path d="M15 6l3 -3l3 3"></path>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="col-md-6 col-xl-6 col-6">
                                <a href="{{route('student.my-attendance')}}">
                                    <div class="card bg-grd-purple order-card">
                                        <div class="card-body d-flex justify-content-between align-items-center">
                                            <div class="title">
                                                <h1 class="text-white">{{$myCurrentAttendance->count()}}</h1>
                                                <h5 class="text-white">Attendance</h5>
                                            </div>
                                            <div class="icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-linejoin="round" width="64" height="64"
                                                    stroke-width="0.75">
                                                    <path
                                                        d="M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6">
                                                    </path>
                                                    <path d="M16 3v4"></path>
                                                    <path d="M8 3v4"></path>
                                                    <path d="M4 11h16"></path>
                                                    <path d="M15 19l2 2l4 -4"></path>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section__row mb-4">
        <div class="row">
            <div class="col-md-10 m-auto std__block">
                <div class="card p-3">
                    <div class="card-block">
                        <div class="content">
                            <div class="heading">
                                <h4>Academics</h4>
                            </div>
                            <div class="body mt-5">
                                <div class="row">
                                    <div class="col-md-2 col-4">
                                        <div class="item text-center mb-4">
                                            <a href="{{route('student.class-time-table')}}" class="icon__c__1">
                                                <div class="icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="64"
                                                        height="64" viewBox="0 0 24 24" fill="none"
                                                        stroke="currentColor" stroke-width=".75"
                                                        stroke-linecap="round" stroke-linejoin="round">
                                                        <path
                                                            d="M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z" />
                                                        <path d="M16 3v4" />
                                                        <path d="M8 3v4" />
                                                        <path d="M4 11h16" />
                                                        <path d="M8 14v4" />
                                                        <path d="M12 14v4" />
                                                        <path d="M16 14v4" />
                                                    </svg>
                                                </div>
                                                <div class="label">
                                                    <label>Class Timetable</label>
                                                </div>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-md-2 col-4">
                                        <div class="item text-center mb-4">
                                            <a href="{{ route('student.syllabus') }}" class="icon__c__2">
                                                <div class="icon">

                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="none"
                                                        stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" width="64" height="64"
                                                        stroke-width=".75">
                                                        <path
                                                            d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2">
                                                        </path>
                                                        <path
                                                            d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z">
                                                        </path>
                                                        <path d="M9 12h6"></path>
                                                        <path d="M9 16h6"></path>
                                                    </svg>

                                                </div>
                                                <div class="label">
                                                    <label>Syllabus Status</label>
                                                </div>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-md-2 col-4">
                                        <div class="item text-center mb-4">
                                            <a href="{{route('student.my-attendance')}}" class="icon__c__3">
                                                <div class="icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="none"
                                                        stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" width="64" height="64"
                                                        stroke-width="0.75">
                                                        <path
                                                            d="M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6">
                                                        </path>
                                                        <path d="M16 3v4"></path>
                                                        <path d="M8 3v4"></path>
                                                        <path d="M4 11h16"></path>
                                                        <path d="M15 19l2 2l4 -4"></path>
                                                    </svg>
                                                </div>
                                                <div class="label">
                                                    <label>Attendance</label>
                                                </div>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-md-2 col-4">
                                        <div class="item text-center mb-4">
                                            <a href="" class="icon__c__4">
                                                <div class="icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="none"
                                                        stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" width="64" height="64"
                                                        stroke-width="0.75">
                                                        <path d="M3.5 5.5l1.5 1.5l2.5 -2.5"></path>
                                                        <path d="M3.5 11.5l1.5 1.5l2.5 -2.5"></path>
                                                        <path d="M3.5 17.5l1.5 1.5l2.5 -2.5"></path>
                                                        <path d="M11 6l9 0"></path>
                                                        <path d="M11 12l9 0"></path>
                                                        <path d="M11 18l9 0"></path>
                                                    </svg>
                                                </div>
                                                <div class="label">
                                                    <label>Examinations</label>
                                                </div>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="col-md-2 col-4">
                                        <div class="item text-center mb-4">
                                            <a href="{{ route('student.homework-history') }}" class="icon__c__3">
                                                <div class="icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="none"
                                                        stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" width="64" height="64"
                                                        stroke-width="0.75">
                                                        <path d="M13 5h8"></path>
                                                        <path d="M13 9h5"></path>
                                                        <path d="M13 15h8"></path>
                                                        <path d="M13 19h5"></path>
                                                        <path
                                                            d="M3 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z">
                                                        </path>
                                                        <path
                                                            d="M3 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z">
                                                        </path>
                                                    </svg>
                                                </div>
                                                <div class="label">
                                                    <label>Homework</label>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-4">
                                        <div class="item text-center mb-4">
                                            <a href="{{ route('student.my-mark-sheet') }}" class="icon__c__2">
                                                <div class="icon">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        viewBox="0 0 24 24" fill="none"
                                                        stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" width="64" height="64"
                                                        stroke-width="0.75">
                                                        <path
                                                            d="M14 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5">
                                                        </path>
                                                        <path d="M11 16h-5a2 2 0 0 0 -2 2"></path>
                                                        <path d="M15 16l3 -3l3 3"></path>
                                                        <path d="M18 13v9"></path>
                                                    </svg>
                                                </div>
                                                <div class="label">
                                                    <label>Result Book</label>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="section__row">
        <div class="row">
            <div class="col-md-10 m-auto std__block">
                <div class="row">
                    <div class="col-md-7 col-lg-7">
                        <div class="card p-3">
                            <div class="card-block">
                                <div class="content">
                                    <div class="heading">
                                        <h4>Payments & Others</h4>
                                    </div>
                                    <div class="body mt-5">
                                        <div class="row">
                                            <div class="col-md-3 col-4">
                                                <div class="item text-center mb-4">
                                                    <a href="{{route('student.my-fees')}}" class="icon__c__3">
                                                        <div class="icon">
                                                            <img src="{{ asset('student/assets/images/icon/all-fees.png') }}"
                                                                height="128" width="128" />
                                                        </div>
                                                        <div class="label">
                                                            <label>My Fees</label>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="col-md-3 col-4">
                                                <div class="item text-center mb-4">
                                                    <a href="{{route('student.due-fees')}}" class="icon__c__4">
                                                        <div class="icon">
                                                            <img src="{{ asset('student/assets/images/icon/pay-bill.png') }}"
                                                                height="128" width="128" />
                                                        </div>
                                                        <div class="label">
                                                            <label>Due Fee</label>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="col-md-3 col-4">
                                                <div class="item text-center mb-4">
                                                    <a href="{{route('student.apply-leave')}}" class="icon__c__2">
                                                        <div class="icon">
                                                            <img src="{{ asset('student/assets/images/icon/apply-leave.png') }}"
                                                                height="128" width="128" />
                                                        </div>
                                                        <div class="label">
                                                            <label>Apply Leave</label>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-4">
                                                <div class="item text-center mb-4">
                                                    <a href="{{ route('student.library') }}" class="icon__c__2">
                                                        <div class="icon">
                                                            <img src="{{ asset('student/assets/images/icon/library.png') }}"
                                                                height="99" width="128" />
                                                        </div>
                                                        <div class="label">
                                                            <label>Library</label>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-4">
                                                <div class="item text-center mb-4">
                                                    <a href="{{route('student.my-subjects')}}" class="icon__c__2">
                                                        <div class="icon">
                                                            <img src="{{ asset('student/assets/images/icon/subjects.png') }}"
                                                                height="256" width="256" />
                                                        </div>
                                                        <div class="label">
                                                            <label>My Subjects</label>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-4">
                                                <div class="item text-center mb-4">
                                                    <a href="{{ route('my.notice') }}" class="icon__c__2">
                                                        <div class="icon">
                                                            <img src="{{ asset('student/assets/images/icon/notice.png') }}"
                                                                height="128" width="128" />
                                                        </div>
                                                        <div class="label">
                                                            <label>Notice</label>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5 col-lg-5">
                        <div class="card p-3">
                            <div id='calendar'></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection


@push('scripts')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.7/index.global.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.7/index.global.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        // Embed holidays data into JavaScript
        var holidays = @json($holidays);
        var formattedEvents = holidays.map(holiday => ({
            id: holiday.id, // Optional for backend integration
            title: holiday.title,
            start: holiday.start_date,
            end: holiday.end_date,
        }));
        var calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            editable: false, // Disables drag-and-drop and resizing
            events: formattedEvents, // Load events
            eventClick: false, // Disable event clicking
        });
        calendar.render();
    });
</script>
@endpush