@extends('students-dashboard.app')
@section('content')
    <div class="container-fluid class__timetable">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                <div class="page-header mb-4">
                    <div class="page-block mb-0">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">Class Timetable</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @php
                        $routinesByDay = $classRoutine?->routineDetails?->groupBy('day');
                    @endphp

                    <div class="row">
                        @foreach(['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday'] as $day)
                            <div class="col-12 col-md-6 col-lg-4 mb-4">
                                <div class="card h-100 day-card">
                                    <div class="card-header bg-light">
                                        <h4 class="mb-0">{{ $day }}</h4>
                                    </div>
                                    <div class="card-body p-0">
                                        @if(!isset($routinesByDay[$day]) || $routinesByDay[$day]->isEmpty())
                                            <div class="p-4 text-center text-muted">
                                                No classes scheduled for this day.
                                            </div>
                                        @else
                                            <div class="list-group list-group-flush sub__info">
                                                @foreach($routinesByDay[$day] as $routineDetail)
                                                    <div class="list-group-item">
                                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                                            <h5 class="mb-0 sub__name">{{ $routineDetail->subject->subject_name ?? 'N/A' }}</h5>
                                                            <span class="badge bg-primary" style="padding: 10px 12px;font-size: 13px;font-weight: 400;letter-spacing: 1px;">Room - {{ $routineDetail->class_room_id ?? 'N/A' }}</span>
                                                        </div>
                                                        <div class="small text-muted mb-2">
                                                            <i class="fas fa-user-tie me-1"></i>
                                                            <span class="sub__teacher">{{ $routineDetail->teacher->name ?? 'N/A' }}</span>
                                                        </div>
                                                        <div class="small sub__time">
                                                            <i class="fas fa-clock me-1"></i>
                                                            {{ $routineDetail->start_time }}
                                                            - {{ $routineDetail->end_time }}
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
    <style>
        .day-card {
            transition: transform 0.2s;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .day-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }

        @media (max-width: 768px) {
            .day-card {
                margin-bottom: 1rem;
            }
        }
    </style>
@endsection

