@extends('students-dashboard.app')
@section('content')
<div class="container-fluid my__cl__mate">
    <div class="row">
        <div class="col-12 col-lg-12 col-xl-10 m-auto">
            <div class="page-header">
                <div class="page-block mb-0 mt-3">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title mb-0">
                                <h4 class="mb-0">Due Fees</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card data__table mt-4">
                <div class="card-body table-border-style">
                    <!-- Desktop View (Table) -->
                    <div class="d-none d-md-block">
                        <div class="table-responsive py-2">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="h_stl_1">Month</th>
                                        <th>Total Amount</th>
                                        <th>Due Amount</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody class="day-schedule">

                                    @forelse($dueFees as $dueFee)
                                        <tr class="subject-entry">
                                            <td class="b_stl_1">{{ !empty($dueFee['month']) ? date('F', mktime(0, 0, 0, $dueFee['month'], 1)) : '--' }}</td>
                                            <td>{{ round($dueFee['total_amount']) ?? '0' }}</td>
                                            <td>{{ round($dueFee['due_amount']) ?? '0' }}</td>
                                            <td>
                                                @if($dueFee['due_amount'] > 0)
                                                    {!! getStudentStatusBadge(Status::DUE) !!}
                                                @elseif ($dueFee['due_amount'] == 0 && $dueFee['paid_amount'] > 0)
                                                    {!! getStudentStatusBadge(Status::PAID) !!}
                                                @endif
                                            </td>
                                            <td>
                                                @if($dueFee['due_amount'] > 0)
                                                    <a href="" class="badge bg-primary">Pay</a>
                                                @elseif ($dueFee['due_amount'] == 0 && $dueFee['paid_amount'] > 0)
                                                    <span class="badge bg-success">View</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <td colspan="5" class="text-center">No classes scheduled for this day.</td>
                                    @endforelse

                                    @php
                                        $totalAssignedFee = $dueFees->sum('total_amount');
                                        $totalPaidFee = $dueFees->sum('paid_amount');
                                        $totalDueFee = $dueFees->sum('due_amount');
                                    @endphp

                                    <tr class="table-secondary fw-bold">
                                        <td colspan="1">Grand Total</td>
                                        <td class="text-center">{{ round($totalAssignedFee) }}</td>
                                        <td class="text-center">{{ round($totalDueFee) }}</td>
                                        <td colspan="2"></td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Mobile View (Cards) -->
                    <div class="d-md-none">
                        <div class="card mb-4 bg-light">
                            <div class="card-body">
                                <h6 class="card-title mb-3">Due Fees Summary</h6>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <span class="text-muted d-block">Total Due : <span class="fw-bold text-danger">{{ round($totalDueFee) }}</span></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @forelse($dueFees as $dueFee)
                            <div class="card mb-3 fee-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="card-title mb-0">{{ !empty($dueFee['month']) ? date('F', mktime(0, 0, 0, $dueFee['month'], 1)) : '--' }}</h6>
                                        @if($dueFee['due_amount'] > 0)
                                            {!! getStudentStatusBadge(Status::DUE) !!}
                                        @elseif ($dueFee['due_amount'] == 0 && $dueFee['paid_amount'] > 0)
                                            {!! getStudentStatusBadge(Status::PAID) !!}
                                        @endif
                                    </div>
                                    <div class="fee-details">
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <small class="text-muted">Month:</small>
                                                <div>{{ !empty($dueFee['month']) ? date('F', mktime(0, 0, 0, $dueFee['month'], 1)) : '--' }}</div>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Total Amount:</small>
                                                <div>{{ round($dueFee['total_amount']) ?? '0' }}</div>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Paid Amount:</small>
                                                <div>{{ round($dueFee['paid_amount']) ?? '0' }}</div>
                                            </div>
                                            <div class="col-6">
                                                <small class="text-muted">Due Amount:</small>
                                                <div>{{ round($dueFee['due_amount']) ?? '0' }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 text-end">
                                        @if($dueFee['due_amount'] > 0)
                                            <a href="" class="btn btn-primary btn-sm">Pay Now</a>
                                        @elseif ($dueFee['due_amount'] == 0 && $dueFee['paid_amount'] > 0)
                                            <button class="btn btn-success btn-sm">View Details</button>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-4">
                                <p class="text-muted mb-0">No fees found.</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fee-card {
        border: 1px solid rgba(0,0,0,.125);
        box-shadow: 0 2px 4px rgba(0,0,0,.05);
        transition: all 0.3s ease;
    }
    .fee-card:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,.1);
    }
    .fee-details {
        background-color: #f8f9fa;
        padding: 1rem;
        border-radius: 0.375rem;
        margin-top: 0.5rem;
    }
    /* Add these new styles for table */
    .table thead th {
        color: #333;
    }
    .table tbody td {
        color: #333;
    }
    .subject-entry td {
        color: #333;
    }
</style>
@endsection

