@extends('students-dashboard.app')
@push('styles')
<link rel="stylesheet" href="https://prismjs.com/themes/prism.css">
<script src="https://prismjs.com/prism.js"></script>
<script src="{{asset('assets/vendor/multi-file/js/docs.js')}}"></script>
<style>
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}
/* Firefox */
input[type=number] {
  -moz-appearance: textfield;
}
.select2{
    height: calc(1.5em + .75rem + 7px) !important;
}
th{
    border: 1px solid #ABD4EC;
    width: 20%;
}
</style>
@endpush
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12 col-md-12 col-lg-10 m-auto">
            <div class="page-header mb-4">
                <div class="page-block mb-0">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title mb-0">
                                <h4 class="mb-0">My Homework</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card data__table">
        <div class="card-body table-border-style">
            <!-- Desktop View (Table) -->
            <div class="d-md-block">
                <div class="table-responsive py-2">
                    <table class="table">
                        <tbody class="day-schedule">
                            @if(!empty($homework))
                            <tr>
                                <th class="text-dark">Title</th>
                                <td>{{ $homework->title }}</td>
                            </tr>
                            <tr>
                                <th class="text-dark">Publish Date</th>
                                <td>{{ $homework->homework_date }}</td>
                            </tr>
                            <tr>
                                <th class="text-dark">Submite Date</th>
                                <td>{{ $homework->submission_date }}</td>
                            </tr>

                            <tr>
                                <th class="text-dark">Description</th>
                                <td>{!! $homework->description !!}</td>
                            </tr>
                            <tr>
                                <th class="text-dark">Attachment</th>
                                <td>
                                    @if($homework->attachment)
                                        <a class="btn btn-sm btn-info" href="{{ asset($homework->attachment) }}" target="_blank">Attachment</a>
                                    @else
                                        N/A
                                    @endif
                                </td>
                            </tr>
                            @endif


                        </tbody>
                    </table>



                </div>

                <!-- homework submission form open -->
                @if(empty($existingValue))
                <form action="{{ route('student.homework.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-12 text-danger text-center">You can write answer or upload answer sheet</div>

                    <div class="col-md-8">
                        <div class="form-group">
                            <label for="submission">Write Answer</label>
                            <textarea class="form-control" id="submission" name="answer">{{ old('submission') }}</textarea>
                            @error('submission')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    @if(!empty($homework))
                    <input type="hidden" name="homework_id" value="{{ $homework->id }}">
                    @endif
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="attachment">Upload File <span class="text-danger">You can select multiple file</span></label>
                            <input name="attachment[]" type="file" multiple="multiple" class="multi" maxlength="10" data-maxfile="1024" accept="gif|jpg|png|pdf|xlsx"/>
                            @error('attachment')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="float-end mt-3 flex justify-content-end">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>
                </form>
                @else
                
                @endif
                <!-- homework submission form end -->
            </div>

            <!-- Mobile View (Cards) -->

        </div>
    </div>

        </div>
    </div>
</div>


@endsection

@push('scripts')
<script src="{{asset('assets/vendor/multi-file/js/jquery.form.js')}}" type="text/javascript" language="javascript"></script>
<script src="{{asset('assets/vendor/multi-file/js/jquery.MetaData.js')}}" type="text/javascript" language="javascript"></script>
<script src="{{asset('assets/vendor/multi-file/js/jquery.MultiFile.min.js')}}" type="text/javascript" language="javascript"></script>
<script>
  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

  ga('create', 'UA-1942730-1', 'fyneworks.com');
  ga('send', 'pageview');

</script>
</div><footer id="footer"><p>&copy; Fyneworks</p></footer><script type="text/javascript">var _gaq = _gaq || [];
_gaq.push(['_setAccount', 'UA-1942730-1']);
_gaq.push(['_setDomainName', 'fyneworks.com']);
_gaq.push(['_trackPageview']);
(function() {
        var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
        ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
})();</script>

<script>


    $(document).ready(function () {

        $('.dropify').dropify({
            messages: {
                'default': 'Drag and drop a file here or click',
                'replace': 'Drag and drop or click to replace',
                'remove':  'Remove',
                'error':   'Ooops, something wrong happended.'
            }
        });
    })


</script>
@endpush

