@extends('students-dashboard.app')

@section('content')
<div class="container-fluid">
    <div class="row">
<div class="col-12 col-md-12 col-lg-10 m-auto">
    <div class="card shadow-sm">
        <div class="card-header bg-white d-flex justify-content-between align-items-center py-3">
            <h5 class="mb-0 text-primary">Leave History</h5>
            <a href="{{ route('student.apply-leave') }}" class="btn btn-primary btn-sm rounded-circle">
                <i class="fas fa-plus"></i>
            </a>
        </div>
    </div>
    <div class="row g-4">
        @forelse($leaveHistory as $key => $leave)
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card h-100 leave-card border-0">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div class="leave-type">
                                <span class="badge bg-light text-dark mb-2">
                                    <i class="fas fa-calendar-alt me-1"></i>
                                    {{ $leave->leaveType->name ?? 'N/A' }}
                                </span>
                            </div>
                            <div class="d-flex align-items-center gap-1">
                                @if($leave->status === Status::PENDING)
                                    <a href="{{ route('student.apply-leave.edit', $leave->id) }}" class="badge bg-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="{{ route('student.apply-leave.delete', $leave->id) }}" class="badge bg-danger">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                @endif
                            </div>
                        </div>
                        
                        <div class="leave-info">
                            <div class="info-item mb-3">
                                <small class="text-muted text-uppercase fw-bold">
                                    <i class="fas fa-calendar-day text-primary me-1"></i> Duration - ({{ $leave->requested_days }} days)
                                </small>
                                <div class="mt-2">
                                    <div class="row">
                                        <div class="col-6">
                                            <span class="text-muted">From Date:</span>
                                            <div>{{ date('d-m-Y', strtotime($leave->from_date)) }}</div>
                                        </div>
                                        <div class="col-6">
                                            <span class="text-muted">To Date:</span>
                                            <div>{{ date('d-m-Y', strtotime($leave->to_date)) }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="info-item mb-3">
                                <div class="row">
                                    <div class="col-6">
                                        <small class="text-muted text-uppercase fw-bold">
                                            <i class="fas fa-clock text-primary me-1"></i> Applied On
                                        </small>
                                        <div class="mt-1">
                                            {{ date('d-m-Y', strtotime($leave->created_at)) }}
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <small class="text-muted text-uppercase fw-bold">
                                            <i class="fas fa-check-circle text-primary me-1"></i> Status
                                        </small>
                                        <div class="mt-1">{!! getStudentStatusBadge($leave->status) !!}</div>
                                    </div>
                                </div>
                            </div>

                            <div class="info-item mb-3">
                                <small class="text-muted text-uppercase fw-bold">
                                    <i class="fas fa-comment-alt text-primary me-1"></i> Reason
                                </small>
                                <div class="mt-1">
                                    
                                    {{ $leave->leave_reason }}
                                </div>
                            </div>

                            @if($leave->attachment)
                                <div class="mt-3">
                                    <a href="{{ asset($leave->attachment) }}" 
                                       class="btn btn-outline-primary btn-sm w-100 rounded-3" 
                                       target="_blank">
                                        <i class="fas fa-paperclip me-1"></i> View Attachment
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="text-center py-5">
                    <i class="fas fa-calendar-times text-muted mb-3" style="font-size: 3rem;"></i>
                    <h6 class="text-muted">No leave history found</h6>
                    <a href="{{ route('student.apply-leave') }}" class="btn btn-primary btn-sm mt-3">
                        Apply for Leave
                    </a>
                </div>
            </div>
        @endforelse
    </div>
</div>
</div>
</div>

<style>
.leave-card {
    transition: all 0.3s ease;
    box-shadow: 0 10px 20px rgba(0,0,0,0.08);
    background: #ffffff;
    border-radius: 12px;
}

.leave-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.08);
}

.info-item small {
    display: block;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
}

.info-item div {
    color: #2c3e50;
    font-size: 0.95rem;
}

.badge {
    padding: 0.5rem 1rem;
    border-radius: 50rem;
    font-weight: 500;
}

.bg-primary-subtle {
    background-color: rgba(var(--bs-primary-rgb), 0.1);
}

.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.05);
}

@media (max-width: 768px) {
    .card-body {
        padding: 1rem;
    }
    
    .leave-card {
        border-radius: 10px;
    }
    
    .info-item {
        margin-bottom: 0.75rem;
    }
}

/* Dark mode support */
/* @media (prefers-color-scheme: dark) {
    .leave-card {
        background: #2d3436;
    }
    
    .info-item div {
        color: #f5f6fa;
    }
    
    .badge.bg-light {
        background-color: #3d4852 !important;
        color: #f5f6fa !important;
    }
} */
</style>
@endsection