@extends('students-dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-lg-10 m-auto">
                <div class="page-header">
                    <div class="page-block mb-0 mt-4">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">My Attendance History</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Desktop Table View -->
                <div class="d-block">
                    <div class="mt-4 data__table">
                        <div class="card-body1">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th class="h_stl_1">Date</th>
                                        <th class="text-center">Time</th>
                                        <th class="text-center h_stl_2">Status</th>
                                        <th class="text-center">Note</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($attendances as $attendance)
                                        <tr>
                                            <td class="b_stl_1">{{ date('d M Y, D', strtotime($attendance->punch_date)) }}</td>
                                            <td class="text-center"><i class="fas fa-clock text-primary me-1 d-none d-lg-inline-block"></i> {{ $attendance->created_at->format('h:i A') }}</td>
                                            <td class="text-center b_stl_2">
                                                @if($attendance->is_present)
                                                    <span class="badge bg-success">Present</span>
                                                @elseif($attendance->is_absent)
                                                    <span class="badge bg-danger">Absent</span>
                                                @elseif($attendance->is_late)
                                                    <span class="badge bg-warning">Late</span>
                                                @endif
                                            </td>
                                            <td class="text-center">{{ $attendance->note ?? '' }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">No attendance records found</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Mobile Card View -->
                <div class="d-block d-lg-none std__att__card">
                    <div class="row g-4 mt-2">
                        @forelse($attendances as $attendance)
                            <div class="col-12">
                                <div class="card attendance-card border-0">
                                    <div class="card-body p-4">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div class="attendance-date">
                                    <span class="badge bg-light text-dark">
                                        <i class="fas fa-calendar-alt me-1"></i>
                                        {{ date('d M Y, l', strtotime($attendance->punch_date)) }}
                                    </span>
                                            </div>
                                            @if($attendance->is_present)
                                                <span class="badge bg-success">Present</span>
                                            @elseif($attendance->is_absent)
                                                <span class="badge bg-danger">Absent</span>
                                            @elseif($attendance->is_late)
                                                <span class="badge bg-warning">Late</span>
                                            @endif
                                        </div>

                                        <div class="attendance-info">
                                            <div class="info-item mt-3 mb-0">
                                                <small class="text-muted text-uppercase">
                                                    Time
                                                </small>
                                                <div><i class="fas fa-clock text-primary me-1"></i> {{ $attendance->created_at->format('h:i A') }}</div>
                                            </div>

                                            @if($attendance->note)
                                                <div class="info-item">
                                                    <small class="text-muted text-uppercase">
                                                        <i class="fas fa-sticky-note text-primary me-1"></i> Note
                                                    </small>
                                                    <div>{{ $attendance->note }}</div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
{{--                            <div class="col-12 text-center">--}}
{{--                                <div class="alert alert-info">--}}
{{--                                    No attendance records found--}}
{{--                                </div>--}}
{{--                            </div>--}}
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>


    <style>
        .attendance-card {
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
            background: #ffffff;
            border-radius: 12px;
        }

        .attendance-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.12);
        }

        .info-item small {
            display: block;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
        }

        .info-item div {
            color: #2c3e50;
            font-size: 0.95rem;
        }

        .badge {
            padding: 0.5rem 1rem;
            border-radius: 50rem;
            font-weight: 500;
        }

        .card-header {
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .table thead th {
            color: #333;
        }

        .table tbody td {
            color: #333;
        }

        .subject-entry td {
            color: #333;
        }

        .table-secondary {
            background-color: #f8f9fa;
        }

        @media (max-width: 768px) {
            .card-body {
                padding: 1rem;
            }

            .attendance-card {
                border-radius: 10px;
            }

            .info-item {
                margin-bottom: 0.75rem;
            }
        }
    </style>
@endsection
