@extends('students-dashboard.app')
@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                <h5 class="mb-4"></h5>
                <div class="page-header mb-4">
                    <div class="page-block mb-0">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">My Homework</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="data__table">
                    <div class="card-body table-border-style">
                        <!-- Desktop View (Table) -->
                        <div class="d-md-block">
                            <div class="table-responsive py-2">
                                
                                @if(!empty($upcoming))
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Title</th>
                                        <th>Publish Date</th>
                                        <th>Submite Date</th>
                                        <th>Attachment</th>
                                        <th>Marks</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody class="day-schedule">
                                        @foreach($upcoming as $item)
                                            <tr>
                                                <td>{{ $item->title }}</td>
                                                <td>{{ $item->homework_date }}</td>
                                                <td>{{ $item->submission_date }}</td>
                                                <td>
                                                    @if($item->attachment)
                                                        <a class="btn btn-sm btn-info"
                                                           href="{{ asset($item->attachment) }}" target="_blank">Attachment</a>
                                                    @else
                                                        N/A
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($item->homeworkSubmission->id))
                                                      {{$item->homeworkSubmission->marks}} Out Of
                                                    @endif

                                                    {{ $item->marks ?? '0' }}
                                                </td>
                                                <td>
                                                    @if(!empty($item->homeworkSubmission->id))
                                                      <a href="#"
                                                       class="badge bg-primary">Submitted</a>
                                                    @else
                                                    <a href="{{ route('student.homework-view',$item->id)}}"
                                                       class="badge bg-primary">View/Submit</a>
                                                    @endif

                                                    
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <style>
        .fee-card {
            border: 1px solid rgba(0, 0, 0, .125);
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
            transition: all 0.3s ease;
        }

        .fee-card:hover {
            box-shadow: 0 4px 8px rgba(0, 0, 0, .1);
        }

        .fee-details {
            background-color: #f8f9fa;
            padding: 1rem;
            border-radius: 0.375rem;
            margin-top: 0.5rem;
        }

        /* Add these new styles for table */
        .table thead th {
            color: #333;
        }

        .table tbody td {
            color: #333;
        }

        .subject-entry td {
            color: #333;
        }

        .table-secondary {
            background-color: #f8f9fa;
        }

        .fw-bold {
            font-weight: 600;
        }

        .text-success {
            color: #28a745;
        }

        .text-danger {
            color: #dc3545;
        }
    </style>
@endsection

@push('scripts')
    <script>
        $('#exampleModalCenter').on('show.bs.modal', function (event) {
            let button = $(event.relatedTarget) // Button that triggered the modal
            let title = button.data('title')
            let date = button.data('date')
            let attachment = button.data('attachment')
            let description = button.data('description')

            let modal = $(this)
            modal.find('#title').text(title)
            modal.find('#date').text(date)
            if (attachment) {
                modal.find('#attachment').attr('href', attachment).show()
            } else {
                modal.find('#attachment').hide()
            }
            modal.find('#description').text(description)
        })


    </script>
@endpush
