@extends('students-dashboard.app')
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12 col-md-12 col-lg-10 m-auto">
            <h5 class="mb-4"></h5>
            <div class="page-header mb-4">
                <div class="page-block mb-0">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title mb-0">
                                <h4 class="mb-0">Apply For Book</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <!-- <div class="card-header">
                    <h5>Floating labels</h5>
                    <hr>
                </div> -->
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger m-3">
                            <ul class="m-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if(session('success'))
                        <div id="successAlert" class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div id="successAlert" class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <form action="{{route('student.syllabus.store')}}" method="post">
                        @csrf
                        <div class="row g-4">
                            
                            <div class="col-md-6">
                                <div class="form-floating">
                                    @if(!empty($books))
                                    <select class="form-control select2" name="book" required>
                                        <option value="">--Select Book--</option>
                                        @foreach($books as $book)
                                        <option value="{{$book->id}}">{{$book->title}}</option>
                                        @endforeach
                                    </select>
                                    <label for="book_id">Book <span class="text-danger">*</span></label>
                                    @endif

                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="datepicker" name="return_date" required>
                                    <label for="datepicker">Return Date <span class="text-danger">*</span></label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        

            <!-- //bookissue list -->
            @if(!empty($bookissues))
                <div class="card data__table">
                    <div class="card-header"><h5>My Books</h5>
                    </div>
                    <div class="card-body table-border-style">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Request Date</th>
                                    <th>Issue Date</th>
                                    <th title="Estimate Return Date">ERD Date</th>
                                    <th >Return Date</th>
                                    <th>Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($bookissues as $key=>$bookissue)
                                <tr>
                                    <td>{{++$key}}</td>
                                    <td>{{$bookissue->booklist->title ?? 'N/A'}}</td>
                                    <td>{{ \Carbon\Carbon::parse($bookissue->created_at)->format('d-m-Y')}}</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td class="text-capitalize">{{$bookissue->status ?? 'N/A'}}</td>
                                </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
    $(document).ready(function () {
        const today = new Date();
        const nextWeek = new Date(today);
        nextWeek.setDate(today.getDate() + 7);

      $('#datepicker').datepicker({
        format: 'dd-mm-yyyy', // Format of the date
        autoclose: true,      // Close the picker after date selection
        todayHighlight: true, // Highlight the current date
      }).datepicker('setDate', nextWeek); // Set the current date as the default
    });

</script>
@endpush