@extends('students-dashboard.app')
@section('content')
    <div class="col-12 col-lg-12 col-xl-10 m-auto">

        <div class="page-header">
            <div class="page-block mb-0 mt-3">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="page-header-title mb-0">
                            <h4 class="mb-0">My Notice</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="data__table mt-4">
            <div class="card-body table-border-style">
                <div class="table-responsive py-2">
                    <table class="table">
                        <thead>
                            <tr>
                                <th class="h_stl_1">Title</th>
                                <th>Publish Date</th>
                                <th>Attachment</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody class="day-schedule">
                            @if (!empty($all_notice))
                                @foreach ($all_notice as $notice)
                                    <tr class="subject-entry">
                                        <td class="b_stl_1">{{ Str::limit($notice['title'], 80) }}</td>
                                        <td>{{ $notice['publish_date'] }}</td>
                                        <td>
                                            @if ($notice['attachment'])
                                                <a class="badge bg-primary" href="{{ asset($notice['attachment']) }}"
                                                    target="_blank">Attachment</a>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <a href="{{ route('my.notice.show', ['id' => $notice->id]) }}"
                                                class="badge bg-primary">View</a>

                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
