@extends('students-dashboard.app')
@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                <div class="page-header">
                    <div class="page-block mb-0">
                        <div class="row align-items-center">
                            <div class="col-md-12">
                                <div class="page-header-title mb-0">
                                    <h4 class="mb-0">My Subjects</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @if($mySubjects->isEmpty())
                    <div class="text-center py-5">
                        <i class="fas fa-books text-muted mb-3" style="font-size: 3rem;"></i>
                        <p class="text-muted">No subjects assigned yet.</p>
                    </div>
                @else
                    <div class="row g-3">
                        @foreach($mySubjects as $mySubject)
                            <div class="col-12 col-md-6 col-lg-4">
                                <div class="card h-100 shadow-sm">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div
                                                class="subject-icon rounded-circle d-flex align-items-center justify-content-center">
                                                <i class="fas fa-book"></i>
                                            </div>
                                            <div class="ms-3">
                                                <h5 class="mb-1">{{ $mySubject->subject->subject_name ?? 'N/A' }}</h5>
                                            </div>
                                        </div>

                                        <div class="subject-details">
                                            <div class="mb-2">
                                                <span class="teacher__name">Code: </span>
                                                {{ $mySubject->subject->subject_code ?? 'N/A' }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    </div>

    <style>
        .subject-icon {
            width: 50px;
            height: 50px;
            background-color: #e3f2fd;
            color: #1976d2;
            font-size: 1.2rem;
        }

        .subject-details {
            font-size: 1rem;
        }

        .card {
            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-3px);
        }

        @media (max-width: 768px) {
            .card {
                margin-bottom: 1rem;
            }
        }
    </style>
@endsection

