@extends('students-dashboard.app')

@section('content')
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Dancing+Script:wght@400..700&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=PT+Sans:ital,wght@0,400;0,700;1,400;1,700&family=Poppins:ital,wght@0,200;0,300;1,200;1,300;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap');

        .list-unstyled li .lesson-name{
        padding-left: 7px;
    }
    .list-unstyled li ul {
        padding-left: 21px;
        list-style: none;
    }

        body {
            font-family: "Roboto", sans-serif;
            font-style: normal;
        }
        a {
            text-decoration: none;
        }
        .container {
            max-width: 860px;
            padding: 20px 10px;
            margin: auto;
            width: 100%;
        }
        .first-row {
            padding: 20px 10px;
            background-color: transparent;
            border: 3px double #ccc;
        }
        table, th, td {
            border: 1px solid black;
            border-collapse: collapse;
        }

        .first-table-wrapper {
            display: flex;
            gap: 20px;
            justify-content: center;
            margin-top: 15px;
            flex-wrap: nowrap;
        }

        .left-side {
            width: 30% !important;
            text-align: center;
        }

        .left-side h2 {
            font-size: 22px;
            width: 266px;
        }

        .left-side a {
            background-color: #000;
            padding: 8px 10px;
            color: #fff;
            display: inline-block;
            border-radius: 4px;
            cursor: pointer;
        }

        .result-table {
            border: 2px solid #565656;
            margin-top: 20px;
        }

        .second-and-third-wrapper {
            height: 560px;
        }

        .second-table-wrapper {
            margin-top: 25px;
        }

        .third-table-wrapper {
            display: flex;
            gap: 20px;
            margin-top: 25px;
        }

        .last-table-wrapper {
            margin-top: 25px;
        }

        .sig {
            font-family: "Dancing Script", cursive;
            font-weight: 600;
            text-align: center;
        }

        table tr td {
            padding-left: 5px;
        }

        .col-height {
            height: 34px;
        }

        .bg-gray {
            background-color: #e9e9e9;
        }

        /*//water-mark*/
        .container .first-row {
            position: relative;
        }

        .container .first-row .ms__icon {
            /* background-image: url({{ asset('/default/icon-marksheet1.png') }}); */
            position: absolute;
            background-repeat: no-repeat;
            background-position: center;
            background-size: contain;
            width: 349px;
            height: 349px;
            opacity: .15;
            left: 37%;
            top: 48%;
        }

        .middle-side {
            width: 30% !important;
        }

        .right-side {
            width: 40% !important;
        }

        .work-information {
            width: 40% !important;
        }

        .conduct-info {
            width: 60% !important;
        }

        /* Mobile styles */
        @media screen and (max-width: 768px) {
            .first-table-wrapper {
                flex-wrap: wrap;
            }

            .first-table-wrapper > div,
            .left-side,
            .middle-side,
            .right-side,
            .work-information,
            .conduct-info {
                width: 100% !important;
                margin-bottom: 20px;
            }
            
            .second-and-third-wrapper {
                height: auto;
            }
            
            .third-table-wrapper {
                flex-direction: column;
            }
            
            .third-table-wrapper > div {
                width: 100% !important;
            }
            
            .result-table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            table {
                font-size: 14px;
            }
            
            .container .first-row .ms__icon {
                width: 200px;
                height: 200px;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
            }
            
            .left-side h2 {
                width: 100%;
                font-size: 18px;
            }
        }

        @media print {
            .btn-primary {
                display: none;
            }

            .card {
                border: none !important;
            }

            .container-fluid {
                padding: 0 !important;
            }

            .result-table {
                page-break-inside: avoid;
            }
            
            .third-table-wrapper {
                page-break-inside: avoid;
            }
        }
     
    </style>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12 col-md-12 col-lg-10 m-auto">
                    <div class="card-body card__head">
                        <form method="GET" action="{{ route('student.syllabus.search') }}">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                                        <select name="exam_id" class="form-control select2 exam_id" id="exam_id" required>
                                            <option value="">Exam</option>
                                            @foreach ($exams as $examItem)
                                                <option value="{{ $examItem->id }}" @selected($exam_id == $examItem->id || (!$exam_id && $loop->first)) >
                                                    {{ $examItem->exam_name . ' ' . $examItem->academic_year->year }}
                                                </option>
                                            @endforeach 
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-4 col-md-12 col-sm-12">
                                        @if(!empty($subjects))
                                        <select class="form-control form-control-sm subject_id" id="subject_id" name="subject_id">
                                            <option value="">All Subject</option>
                                            @foreach($subjects as $subject)
                                            <option value="{{ $subject->subject->id ?? 'N/A' }}" @if($subject->subject->id == $subject_id) selected @endif>{{ $subject->subject->subject_name ?? 'N/A' }}</option>
                                            @endforeach
                                        </select>
                                        @endif
                                    </div>
                                    <div class="form-group col-lg-3 col-md-6 col-sm-6">
                                        <button type="submit" class="btn btn-sm btn-info">Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
            </div>

            @if(!empty($lessons))
    <div class="col-12 col-md-12 col-lg-10 m-auto">
    <div class="card data__table">
        <div class="card-body table-border-style">
            <!-- Desktop View (Table) -->
            <div class="d-none d-md-block">
                <div class="table-responsive py-2">
                    <table class="table">
                        <thead>
                            @if(!empty($exam_name))
                            <tr class="hide" id="visible" >
                                <td colspan="5" class="text-left" style="color: white;">@if(!empty($exam_name)) <strong class="font-weight-bold">Exam:</strong> @endif {{ $exam_name ?? '' }}  @if(!empty($class_name)) <strong class="font-weight-bold">Class:</strong> {{ $class_name ?? '' }} @endif</td>
                            </tr>
                            @endif
                            <tr>
                                <th>
                                    <div class="row">
                                        <div class="col-md-6 col-xs-7"> Lesson Topic</div>
                                        <div class="col-md-6 col-xs-5 pl-4">Status</div>
                                    </div>    
                               </th>
                            </tr>
                        </thead>
                        <tbody class="day-schedule">
                            @if(!empty($lessons))
                            @php
                                $displayedSubjects = [];
                            @endphp
                            @foreach($lessons as $lessonKey=>$lesson)
                            <tr>
                                <td>
                                    @if(!in_array($lesson->subject->id, $displayedSubjects))
                                        @php
                                            $displayedSubjects[] = $lesson->subject->id;
                                        @endphp
                                        <h5>{{ $lesson->subject->subject_name }}</h5>
                                    @endif
                                    <ul class="list-unstyled">
                                        <li><h6>{{$lessonKey+1}} <span class="lesson-name">{{$lesson->name}}</span></h6>
                                        <ul>
                                            @if($lesson->lessonTopics->isNotEmpty())
                                            @foreach($lesson->lessonTopics as $topicKey=>$topic)
                                            <li>
                                                <div class="row">
                                                    <div class="col-md-6 col-xs-7"><span class="pr15">{{$lessonKey+1}}.{{$topicKey+1}}</span> {{$topic->name}}</div>
                                                   
                                                    <div class="col-md-6 col-xs-5">
                                                        @if($topic->status)
                                                        <span class="text-black">Completed({{$topic->completed_date}})</span>
                                                        @else
                                                        <span class="text-secondary">Incomplete</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </li>
                                            @endforeach
                                            @else
                                                <em>No topics available</em>
                                            @endif
                                        </ul>
                                        </li>
                                    </ul>
                                </td>        
                            </tr>
                             @endforeach
                         @else
                         <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif

                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Mobile View (Cards) -->
            <div class="d-md-none">
                <div class="table-responsive py-2">
                    <table class="table">
                        <thead>
                            @if(!empty($exam_name))
                            <tr class="hide" id="visible">
                                <td colspan="5" class="text-left">@if(!empty($exam_name)) <strong class="font-weight-bold">Exam:</strong> @endif {{ $exam_name ?? '' }}  @if(!empty($class_name)) <strong class="font-weight-bold">Class:</strong> {{ $class_name ?? '' }} @endif</td>
                            </tr>
                            @endif
                            <tr>
                                <th>
                                    <div class="row">
                                        <div class="col-md-6 col-xs-7"> Lesson Topic</div>
                                        <div class="col-md-6 col-xs-5 pl-4">Status</div>
                                    </div>    
                               </th>
                            </tr>
                        </thead>
                        <tbody class="day-schedule">
                            @if(!empty($lessons))
                            @php
                                $displayedSubjects = [];
                            @endphp
                            @foreach($lessons as $lessonKey=>$lesson)
                            <tr>
                                <td>
                                    @if(!in_array($lesson->subject->id, $displayedSubjects))
                                        @php
                                            $displayedSubjects[] = $lesson->subject->id;
                                        @endphp
                                        <h5>{{ $lesson->subject->subject_name }}</h5>
                                    @endif
                                    <ul class="list-unstyled">
                                        <li><h6>{{$lessonKey+1}} <span class="lesson-name">{{$lesson->name}}</span></h6>
                                        <ul>
                                            @if($lesson->lessonTopics->isNotEmpty())
                                            @foreach($lesson->lessonTopics as $topicKey=>$topic)
                                            <li>
                                                <div class="row">
                                                    <div class="col-md-6 col-xs-7"><span class="pr15">{{$lessonKey+1}}.{{$topicKey+1}}</span> {{$topic->name}}</div>
                                                   
                                                    <div class="col-md-6 col-xs-5">
                                                        @if($topic->status)
                                                        <span class="text-black">Completed({{$topic->completed_date}})</span>
                                                        @else
                                                        <span class="text-secondary">Incomplete</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </li>
                                            @endforeach
                                            @else
                                                <em>No topics available</em>
                                            @endif
                                        </ul>
                                        </li>
                                    </ul>
                                </td>        
                            </tr>
                             @endforeach
                         @else
                         <tr><td colspan="6" class="text-center">No data available in table</td></tr>
                        @endif

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    </div>
@endif

        </div>
    </div>

@endsection
